/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import java.security.AccessController;
import javafx.application.Platform;
import javafx.scene.input.TransferMode;

class GlassSceneDnDEventHandler {
    private final GlassScene scene;

    public GlassSceneDnDEventHandler(GlassScene scene) {
        this.scene = scene;
    }

    private double getPlatformScale() {
        Window w;
        View view = this.scene.getPlatformView();
        if (view != null && (w = view.getWindow()) != null) {
            return w.getPlatformScale();
        }
        return 1.0;
    }

    public TransferMode handleDragEnter(int x, int y, int xAbs, int yAbs, TransferMode recommendedTransferMode, ClipboardAssistance dropTargetAssistant) {
        assert (Platform.isFxApplicationThread());
        return AccessController.doPrivileged(() -> {
            if (this.scene.dropTargetListener != null) {
                double pScale = this.getPlatformScale();
                QuantumClipboard dragboard = QuantumClipboard.getDragboardInstance(dropTargetAssistant, false);
                return this.scene.dropTargetListener.dragEnter((double)x / pScale, (double)y / pScale, (double)xAbs / pScale, (double)yAbs / pScale, recommendedTransferMode, dragboard);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public void handleDragLeave(ClipboardAssistance dropTargetAssistant) {
        assert (Platform.isFxApplicationThread());
        AccessController.doPrivileged(() -> {
            if (this.scene.dropTargetListener != null) {
                this.scene.dropTargetListener.dragExit(0.0, 0.0, 0.0, 0.0);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public TransferMode handleDragDrop(int x, int y, int xAbs, int yAbs, TransferMode recommendedTransferMode, ClipboardAssistance dropTargetAssistant) {
        assert (Platform.isFxApplicationThread());
        return AccessController.doPrivileged(() -> {
            if (this.scene.dropTargetListener != null) {
                double pScale = this.getPlatformScale();
                return this.scene.dropTargetListener.drop((double)x / pScale, (double)y / pScale, (double)xAbs / pScale, (double)yAbs / pScale, recommendedTransferMode);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public TransferMode handleDragOver(int x, int y, int xAbs, int yAbs, TransferMode recommendedTransferMode, ClipboardAssistance dropTargetAssistant) {
        assert (Platform.isFxApplicationThread());
        return AccessController.doPrivileged(() -> {
            if (this.scene.dropTargetListener != null) {
                double pScale = this.getPlatformScale();
                return this.scene.dropTargetListener.dragOver((double)x / pScale, (double)y / pScale, (double)xAbs / pScale, (double)yAbs / pScale, recommendedTransferMode);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public void handleDragStart(int button, int x, int y, int xAbs, int yAbs, ClipboardAssistance dragSourceAssistant) {
        assert (Platform.isFxApplicationThread());
        AccessController.doPrivileged(() -> {
            if (this.scene.dragGestureListener != null) {
                double pScale = this.getPlatformScale();
                QuantumClipboard dragboard = QuantumClipboard.getDragboardInstance(dragSourceAssistant, true);
                this.scene.dragGestureListener.dragGestureRecognized((double)x / pScale, (double)y / pScale, (double)xAbs / pScale, (double)yAbs / pScale, button, dragboard);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public void handleDragEnd(TransferMode performedTransferMode, ClipboardAssistance dragSourceAssistant) {
        assert (Platform.isFxApplicationThread());
        AccessController.doPrivileged(() -> {
            try {
                if (this.scene.dragSourceListener != null) {
                    this.scene.dragSourceListener.dragDropEnd(0.0, 0.0, 0.0, 0.0, performedTransferMode);
                }
            }
            finally {
                QuantumClipboard.releaseCurrentDragboard();
            }
            return null;
        }, this.scene.getAccessControlContext());
    }
}

