/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.paint;

import com.sun.prism.paint.Paint;
import java.nio.ByteBuffer;

public final class Color
extends Paint {
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private final int argb;
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public Color(float r, float g, float b, float a) {
        super(Paint.Type.COLOR, false, false);
        int ia = (int)(255.0 * (double)a);
        int ir = (int)(255.0 * (double)r * (double)a);
        int ig = (int)(255.0 * (double)g * (double)a);
        int ib = (int)(255.0 * (double)b * (double)a);
        this.argb = ia << 24 | ir << 16 | ig << 8 | ib << 0;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public int getIntArgbPre() {
        return this.argb;
    }

    public void putRgbaPreBytes(byte[] arr, int offset) {
        arr[offset + 0] = (byte)(this.argb >> 16 & 0xFF);
        arr[offset + 1] = (byte)(this.argb >> 8 & 0xFF);
        arr[offset + 2] = (byte)(this.argb & 0xFF);
        arr[offset + 3] = (byte)(this.argb >> 24 & 0xFF);
    }

    public void putBgraPreBytes(ByteBuffer buf) {
        buf.put((byte)(this.argb & 0xFF));
        buf.put((byte)(this.argb >> 8 & 0xFF));
        buf.put((byte)(this.argb >> 16 & 0xFF));
        buf.put((byte)(this.argb >> 24 & 0xFF));
    }

    public float getRed() {
        return this.r;
    }

    public float getRedPremult() {
        return this.r * this.a;
    }

    public float getGreen() {
        return this.g;
    }

    public float getGreenPremult() {
        return this.g * this.a;
    }

    public float getBlue() {
        return this.b;
    }

    public float getBluePremult() {
        return this.b * this.a;
    }

    public float getAlpha() {
        return this.a;
    }

    @Override
    public boolean isOpaque() {
        return this.a >= 1.0f;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Color)) {
            return false;
        }
        Color other = (Color)obj;
        return this.r == other.r && this.g == other.g && this.b == other.b && this.a == other.a;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Float.floatToIntBits(this.r);
        hash = 53 * hash + Float.floatToIntBits(this.g);
        hash = 53 * hash + Float.floatToIntBits(this.b);
        hash = 53 * hash + Float.floatToIntBits(this.a);
        return hash;
    }

    public String toString() {
        return "Color[r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "]";
    }
}

