/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.dom;

import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    private final long peer;

    NamedNodeMapImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static NamedNodeMap create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new NamedNodeMapImpl(peer);
    }

    long getPeer() {
        return this.peer;
    }

    public boolean equals(Object that) {
        return that instanceof NamedNodeMapImpl && this.peer == ((NamedNodeMapImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    static long getPeer(NamedNodeMap arg) {
        return arg == null ? 0L : ((NamedNodeMapImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static NamedNodeMap getImpl(long peer) {
        return NamedNodeMapImpl.create(peer);
    }

    @Override
    public int getLength() {
        return NamedNodeMapImpl.getLengthImpl(this.getPeer());
    }

    static native int getLengthImpl(long var0);

    @Override
    public Node getNamedItem(String name) {
        return NodeImpl.getImpl(NamedNodeMapImpl.getNamedItemImpl(this.getPeer(), name));
    }

    static native long getNamedItemImpl(long var0, String var2);

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        return NodeImpl.getImpl(NamedNodeMapImpl.setNamedItemImpl(this.getPeer(), NodeImpl.getPeer(node)));
    }

    static native long setNamedItemImpl(long var0, long var2);

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        return NodeImpl.getImpl(NamedNodeMapImpl.removeNamedItemImpl(this.getPeer(), name));
    }

    static native long removeNamedItemImpl(long var0, String var2);

    @Override
    public Node item(int index) {
        return NodeImpl.getImpl(NamedNodeMapImpl.itemImpl(this.getPeer(), index));
    }

    static native long itemImpl(long var0, int var2);

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) {
        return NodeImpl.getImpl(NamedNodeMapImpl.getNamedItemNSImpl(this.getPeer(), namespaceURI, localName));
    }

    static native long getNamedItemNSImpl(long var0, String var2, String var3);

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        return NodeImpl.getImpl(NamedNodeMapImpl.setNamedItemNSImpl(this.getPeer(), NodeImpl.getPeer(node)));
    }

    static native long setNamedItemNSImpl(long var0, long var2);

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return NodeImpl.getImpl(NamedNodeMapImpl.removeNamedItemNSImpl(this.getPeer(), namespaceURI, localName));
    }

    static native long removeNamedItemNSImpl(long var0, String var2, String var3);

    private static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            NamedNodeMapImpl.dispose(this.peer);
        }
    }
}

