/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import javafx.animation.Interpolator;
import javafx.beans.NamedArg;
import javafx.beans.value.WritableBooleanValue;
import javafx.beans.value.WritableDoubleValue;
import javafx.beans.value.WritableFloatValue;
import javafx.beans.value.WritableIntegerValue;
import javafx.beans.value.WritableLongValue;
import javafx.beans.value.WritableNumberValue;
import javafx.beans.value.WritableValue;

public final class KeyValue {
    private static final Interpolator DEFAULT_INTERPOLATOR = Interpolator.LINEAR;
    private final Type type;
    private final WritableValue<?> target;
    private final Object endValue;
    private final Interpolator interpolator;

    @Deprecated
    public Type getType() {
        return this.type;
    }

    public WritableValue<?> getTarget() {
        return this.target;
    }

    public Object getEndValue() {
        return this.endValue;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public <T> KeyValue(@NamedArg(value="target") WritableValue<T> target, @NamedArg(value="endValue") T endValue, @NamedArg(value="interpolator") Interpolator interpolator) {
        if (target == null) {
            throw new NullPointerException("Target needs to be specified");
        }
        if (interpolator == null) {
            throw new NullPointerException("Interpolator needs to be specified");
        }
        this.target = target;
        this.endValue = endValue;
        this.interpolator = interpolator;
        this.type = target instanceof WritableNumberValue ? (target instanceof WritableDoubleValue ? Type.DOUBLE : (target instanceof WritableIntegerValue ? Type.INTEGER : (target instanceof WritableFloatValue ? Type.FLOAT : (target instanceof WritableLongValue ? Type.LONG : Type.OBJECT)))) : (target instanceof WritableBooleanValue ? Type.BOOLEAN : Type.OBJECT);
    }

    public <T> KeyValue(@NamedArg(value="target") WritableValue<T> target, @NamedArg(value="endValue") T endValue) {
        this(target, endValue, DEFAULT_INTERPOLATOR);
    }

    public String toString() {
        return "KeyValue [target=" + this.target + ", endValue=" + this.endValue + ", interpolator=" + this.interpolator + "]";
    }

    public int hashCode() {
        assert (this.target != null && this.interpolator != null);
        int prime = 31;
        int result = 1;
        result = 31 * result + this.target.hashCode();
        result = 31 * result + (this.endValue == null ? 0 : this.endValue.hashCode());
        result = 31 * result + this.interpolator.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof KeyValue) {
            KeyValue keyValue = (KeyValue)obj;
            assert (this.target != null && this.interpolator != null && keyValue.target != null && keyValue.interpolator != null);
            return this.target.equals(keyValue.target) && (this.endValue == null ? keyValue.endValue == null : this.endValue.equals(keyValue.endValue)) && this.interpolator.equals(keyValue.interpolator);
        }
        return false;
    }

    @Deprecated
    public static enum Type {
        BOOLEAN,
        DOUBLE,
        FLOAT,
        INTEGER,
        LONG,
        OBJECT;

    }
}

