/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.VetoableListDecorator;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.LayoutFlags;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.TempState;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.PropertyHelper;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.stage.Window;

public abstract class Parent
extends Node {
    static final int DIRTY_CHILDREN_THRESHOLD = 10;
    private static final boolean warnOnAutoMove = PropertyHelper.getBooleanProperty("javafx.sg.warn");
    private static final int REMOVED_CHILDREN_THRESHOLD = 20;
    private boolean removedChildrenOptimizationDisabled = false;
    private final Set<Node> childSet = new HashSet<Node>();
    private int startIdx = 0;
    private int pgChildrenSize = 0;
    private boolean childrenTriggerPermutation = false;
    private List<Node> removed;
    private boolean geomChanged;
    private boolean childSetModified;
    private final ObservableList<Node> children = new VetoableListDecorator<Node>((ObservableList)new TrackableObservableList<Node>(){

        @Override
        protected void onChanged(ListChangeListener.Change<Node> c) {
            boolean relayout;
            block17: {
                Parent.this.unmodifiableManagedChildren = null;
                relayout = false;
                if (Parent.this.childSetModified) {
                    while (c.next()) {
                        int i;
                        int from = c.getFrom();
                        int to = c.getTo();
                        for (int i2 = from; i2 < to; ++i2) {
                            Node n = (Node)Parent.this.children.get(i2);
                            if (n.getParent() == null || n.getParent() == Parent.this) continue;
                            if (warnOnAutoMove) {
                                System.err.println("WARNING added to a new parent without first removing it from its current");
                                System.err.println("    parent. It will be automatically removed from its current parent.");
                                System.err.println("    node=" + n + " oldparent= " + n.getParent() + " newparent=" + this);
                            }
                            n.getParent().children.remove(n);
                            if (!warnOnAutoMove) continue;
                            Thread.dumpStack();
                        }
                        List<Node> removed = c.getRemoved();
                        int removedSize = removed.size();
                        for (i = 0; i < removedSize; ++i) {
                            Node n = removed.get(i);
                            if (!n.isManaged()) continue;
                            relayout = true;
                        }
                        for (i = from; i < to; ++i) {
                            Node node = (Node)Parent.this.children.get(i);
                            if (node.isManaged() || node instanceof Parent && ((Parent)node).layoutFlag != LayoutFlags.CLEAN) {
                                relayout = true;
                            }
                            node.setParent(Parent.this);
                            node.setScenes(Parent.this.getScene(), Parent.this.getSubScene());
                            if (!node.isVisible()) continue;
                            Parent.this.geomChanged = true;
                            Parent.this.childIncluded(node);
                        }
                    }
                    if (Parent.this.dirtyChildren == null && Parent.this.children.size() > 10) {
                        Parent.this.dirtyChildren = new ArrayList(20);
                        if (Parent.this.dirtyChildrenCount > 0) {
                            int size = Parent.this.children.size();
                            for (int i = 0; i < size; ++i) {
                                Node ch = (Node)Parent.this.children.get(i);
                                if (!ch.isVisible() || !ch.boundsChanged) continue;
                                Parent.this.dirtyChildren.add(ch);
                            }
                        }
                    }
                } else {
                    while (c.next()) {
                        int i;
                        List<Node> removed = c.getRemoved();
                        int removedSize = removed.size();
                        for (i = 0; i < removedSize; ++i) {
                            if (!removed.get(i).isManaged()) continue;
                            relayout = true;
                            break block17;
                        }
                        int to = c.getTo();
                        for (i = c.getFrom(); i < to; ++i) {
                            if (!((Node)Parent.this.children.get(i)).isManaged()) continue;
                            relayout = true;
                            break block17;
                        }
                    }
                }
            }
            if (relayout) {
                Parent.this.requestLayout();
            }
            if (Parent.this.geomChanged) {
                Parent.this.impl_geomChanged();
            }
            c.reset();
            c.next();
            if (Parent.this.startIdx > c.getFrom()) {
                Parent.this.startIdx = c.getFrom();
            }
            Parent.this.impl_markDirty(DirtyBits.PARENT_CHILDREN);
            Parent.this.impl_markDirty(DirtyBits.NODE_FORCE_SYNC);
        }
    }){

        @Override
        protected void onProposedChange(List<Node> newNodes, int[] toBeRemoved) {
            int i;
            Window w;
            Scene scene = Parent.this.getScene();
            if (scene != null && (w = scene.getWindow()) != null && w.impl_getPeer() != null) {
                Toolkit.getToolkit().checkFxUserThread();
            }
            Parent.this.geomChanged = false;
            long newLength = Parent.this.children.size() + newNodes.size();
            int removedLength = 0;
            for (i = 0; i < toBeRemoved.length; i += 2) {
                removedLength += toBeRemoved[i + 1] - toBeRemoved[i];
            }
            newLength -= (long)removedLength;
            if (Parent.this.childrenTriggerPermutation) {
                Parent.this.childSetModified = false;
                return;
            }
            Parent.this.childSetModified = true;
            if (newLength == (long)Parent.this.childSet.size()) {
                Parent.this.childSetModified = false;
                for (i = newNodes.size() - 1; i >= 0; --i) {
                    Node n = newNodes.get(i);
                    if (Parent.this.childSet.contains(n)) continue;
                    Parent.this.childSetModified = true;
                    break;
                }
            }
            for (i = 0; i < toBeRemoved.length; i += 2) {
                for (int j = toBeRemoved[i]; j < toBeRemoved[i + 1]; ++j) {
                    Parent.this.childSet.remove(Parent.this.children.get(j));
                }
            }
            try {
                if (Parent.this.childSetModified) {
                    for (i = newNodes.size() - 1; i >= 0; --i) {
                        Node node = newNodes.get(i);
                        if (node == null) {
                            throw new NullPointerException(this.constructExceptionMessage("child node is null", null));
                        }
                        if (node.getClipParent() != null) {
                            throw new IllegalArgumentException(this.constructExceptionMessage("node already used as a clip", node));
                        }
                        if (!Parent.this.wouldCreateCycle(Parent.this, node)) continue;
                        throw new IllegalArgumentException(this.constructExceptionMessage("cycle detected", node));
                    }
                }
                Parent.this.childSet.addAll(newNodes);
                if ((long)Parent.this.childSet.size() != newLength) {
                    throw new IllegalArgumentException(this.constructExceptionMessage("duplicate children added", null));
                }
            }
            catch (RuntimeException e) {
                Parent.this.childSet.clear();
                Parent.this.childSet.addAll(Parent.this.children);
                throw e;
            }
            if (!Parent.this.childSetModified) {
                return;
            }
            if (Parent.this.removed == null) {
                Parent.this.removed = new ArrayList();
            }
            if (Parent.this.removed.size() + removedLength > 20 || !Parent.this.impl_isTreeVisible()) {
                Parent.this.removedChildrenOptimizationDisabled = true;
            }
            for (i = 0; i < toBeRemoved.length; i += 2) {
                for (int j = toBeRemoved[i]; j < toBeRemoved[i + 1]; ++j) {
                    Node old = (Node)Parent.this.children.get(j);
                    Scene oldScene = old.getScene();
                    if (oldScene != null) {
                        oldScene.generateMouseExited(old);
                    }
                    if (Parent.this.dirtyChildren != null) {
                        Parent.this.dirtyChildren.remove(old);
                    }
                    if (old.isVisible()) {
                        Parent.this.geomChanged = true;
                        Parent.this.childExcluded(old);
                    }
                    if (old.getParent() == Parent.this) {
                        old.setParent(null);
                        old.setScenes(null, null);
                    }
                    if (scene == null || Parent.this.removedChildrenOptimizationDisabled) continue;
                    Parent.this.removed.add(old);
                }
            }
        }

        private String constructExceptionMessage(String cause, Node offendingNode) {
            StringBuilder sb = new StringBuilder("Children: ");
            sb.append(cause);
            sb.append(": parent = ").append(Parent.this);
            if (offendingNode != null) {
                sb.append(", node = ").append(offendingNode);
            }
            return sb.toString();
        }
    };
    private final ObservableList<Node> unmodifiableChildren = FXCollections.unmodifiableObservableList(this.children);
    private List<Node> unmodifiableManagedChildren = null;
    private ObjectProperty<ParentTraversalEngine> impl_traversalEngine;
    private ReadOnlyBooleanWrapper needsLayout;
    LayoutFlags layoutFlag = LayoutFlags.CLEAN;
    boolean performingLayout = false;
    private boolean sizeCacheClear = true;
    private double prefWidthCache = -1.0;
    private double prefHeightCache = -1.0;
    private double minWidthCache = -1.0;
    private double minHeightCache = -1.0;
    private boolean sceneRoot = false;
    boolean layoutRoot = false;
    private final ObservableList<String> stylesheets = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> c) {
            Scene scene = Parent.this.getScene();
            if (scene != null) {
                StyleManager.getInstance().stylesheetsChanged(Parent.this, c);
                c.reset();
                while (c.next() && !c.wasRemoved()) {
                }
                Parent.this.impl_reapplyCSS();
            }
        }
    };
    private BaseBounds tmp = new RectBounds();
    private BaseBounds cachedBounds = new RectBounds();
    private boolean cachedBoundsInvalid;
    private int dirtyChildrenCount;
    private ArrayList<Node> dirtyChildren;
    private Node top;
    private Node left;
    private Node bottom;
    private Node right;
    private Node near;
    private Node far;
    private final int LEFT_INVALID = 1;
    private final int TOP_INVALID = 2;
    private final int NEAR_INVALID = 4;
    private final int RIGHT_INVALID = 8;
    private final int BOTTOM_INVALID = 16;
    private final int FAR_INVALID = 32;
    private Node currentlyProcessedChild;

    @Override
    @Deprecated
    public void impl_updatePeer() {
        List<NGNode> pgnodes;
        super.impl_updatePeer();
        NGGroup peer = (NGGroup)this.impl_getPeer();
        if (Utils.assertionEnabled() && (pgnodes = peer.getChildren()).size() != this.pgChildrenSize) {
            System.err.println("*** pgnodes.size() [" + pgnodes.size() + "] != pgChildrenSize [" + this.pgChildrenSize + "]");
        }
        if (this.impl_isDirty(DirtyBits.PARENT_CHILDREN)) {
            peer.clearFrom(this.startIdx);
            for (int idx = this.startIdx; idx < this.children.size(); ++idx) {
                peer.add(idx, (NGNode)((Node)this.children.get(idx)).impl_getPeer());
            }
            if (this.removedChildrenOptimizationDisabled) {
                peer.markDirty();
                this.removedChildrenOptimizationDisabled = false;
            } else if (this.removed != null && !this.removed.isEmpty()) {
                for (int i = 0; i < this.removed.size(); ++i) {
                    peer.addToRemoved((NGNode)this.removed.get(i).impl_getPeer());
                }
            }
            if (this.removed != null) {
                this.removed.clear();
            }
            this.startIdx = this.pgChildrenSize = this.children.size();
        }
        if (Utils.assertionEnabled()) {
            this.validatePG();
        }
    }

    void validatePG() {
        boolean assertionFailed = false;
        NGGroup peer = (NGGroup)this.impl_getPeer();
        List<NGNode> pgnodes = peer.getChildren();
        if (pgnodes.size() != this.children.size()) {
            System.err.println("*** pgnodes.size validatePG() [" + pgnodes.size() + "] != children.size() [" + this.children.size() + "]");
            assertionFailed = true;
        } else {
            for (int idx = 0; idx < this.children.size(); ++idx) {
                Node n = (Node)this.children.get(idx);
                if (n.getParent() != this) {
                    System.err.println("*** this=" + this + " validatePG children[" + idx + "].parent= " + n.getParent());
                    assertionFailed = true;
                }
                if (n.impl_getPeer() == pgnodes.get(idx)) continue;
                System.err.println("*** pgnodes[" + idx + "] validatePG != children[" + idx + "]");
                assertionFailed = true;
            }
        }
        if (assertionFailed) {
            throw new AssertionError((Object)"validation of PGGroup children failed");
        }
    }

    void printSeq(String prefix, List<Node> nodes) {
        String str = prefix;
        for (Node nn : nodes) {
            str = str + nn + " ";
        }
        System.out.println(str);
    }

    protected ObservableList<Node> getChildren() {
        return this.children;
    }

    public ObservableList<Node> getChildrenUnmodifiable() {
        return this.unmodifiableChildren;
    }

    protected <E extends Node> List<E> getManagedChildren() {
        if (this.unmodifiableManagedChildren == null) {
            this.unmodifiableManagedChildren = new ArrayList<Node>();
            int max = this.children.size();
            for (int i = 0; i < max; ++i) {
                Node e = (Node)this.children.get(i);
                if (!e.isManaged()) continue;
                this.unmodifiableManagedChildren.add(e);
            }
        }
        return this.unmodifiableManagedChildren;
    }

    final void managedChildChanged() {
        this.requestLayout();
        this.unmodifiableManagedChildren = null;
    }

    final void impl_toFront(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(this.children.size() - 1) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(node);
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    final void impl_toBack(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(0) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(0, node);
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    @Override
    void scenesChanged(Scene newScene, SubScene newSubScene, Scene oldScene, SubScene oldSubScene) {
        if (oldScene != null && newScene == null) {
            StyleManager.getInstance().forget(this);
            if (this.removed != null) {
                this.removed.clear();
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((Node)this.children.get(i)).setScenes(newScene, newSubScene);
        }
        boolean awaitingLayout = this.layoutFlag != LayoutFlags.CLEAN;
        this.sceneRoot = newSubScene != null && newSubScene.getRoot() == this || newScene != null && newScene.getRoot() == this;
        boolean bl = this.layoutRoot = !this.isManaged() || this.sceneRoot;
        if (awaitingLayout && newScene != null && this.layoutRoot && newSubScene != null) {
            newSubScene.setDirtyLayout(this);
        }
    }

    @Override
    void setDerivedDepthTest(boolean value) {
        super.setDerivedDepthTest(value);
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)this.children.get(i);
            node.computeDerivedDepthTest();
        }
    }

    @Override
    @Deprecated
    protected void impl_pickNodeLocal(PickRay pickRay, PickResultChooser result) {
        double boundsDistance = this.impl_intersectsBounds(pickRay);
        if (!Double.isNaN(boundsDistance)) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                ((Node)this.children.get(i)).impl_pickNode(pickRay, result);
                if (!result.isClosed()) continue;
                return;
            }
            if (this.isPickOnBounds()) {
                result.offer(this, boundsDistance, PickResultChooser.computePoint(pickRay, boundsDistance));
            }
        }
    }

    @Override
    boolean isConnected() {
        return super.isConnected() || this.sceneRoot;
    }

    @Override
    public Node lookup(String selector) {
        Node n = super.lookup(selector);
        if (n == null) {
            int max = this.children.size();
            for (int i = 0; i < max; ++i) {
                Node node = (Node)this.children.get(i);
                n = node.lookup(selector);
                if (n == null) continue;
                return n;
            }
        }
        return n;
    }

    @Override
    List<Node> lookupAll(Selector selector, List<Node> results) {
        results = super.lookupAll(selector, results);
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)this.children.get(i);
            results = node.lookupAll(selector, results);
        }
        return results;
    }

    @Deprecated
    public final void setImpl_traversalEngine(ParentTraversalEngine value) {
        this.impl_traversalEngineProperty().set(value);
    }

    @Deprecated
    public final ParentTraversalEngine getImpl_traversalEngine() {
        return this.impl_traversalEngine == null ? null : (ParentTraversalEngine)this.impl_traversalEngine.get();
    }

    @Deprecated
    public final ObjectProperty<ParentTraversalEngine> impl_traversalEngineProperty() {
        if (this.impl_traversalEngine == null) {
            this.impl_traversalEngine = new SimpleObjectProperty<ParentTraversalEngine>(this, "impl_traversalEngine");
        }
        return this.impl_traversalEngine;
    }

    protected final void setNeedsLayout(boolean value) {
        if (value) {
            this.markDirtyLayout(true);
        } else if (this.layoutFlag == LayoutFlags.NEEDS_LAYOUT) {
            boolean hasBranch = false;
            int max = this.children.size();
            for (int i = 0; i < max; ++i) {
                Node child = (Node)this.children.get(i);
                if (!(child instanceof Parent) || ((Parent)child).layoutFlag == LayoutFlags.CLEAN) continue;
                hasBranch = true;
                break;
            }
            this.setLayoutFlag(hasBranch ? LayoutFlags.DIRTY_BRANCH : LayoutFlags.CLEAN);
        }
    }

    public final boolean isNeedsLayout() {
        return this.layoutFlag == LayoutFlags.NEEDS_LAYOUT;
    }

    public final ReadOnlyBooleanProperty needsLayoutProperty() {
        if (this.needsLayout == null) {
            this.needsLayout = new ReadOnlyBooleanWrapper(this, "needsLayout", this.layoutFlag == LayoutFlags.NEEDS_LAYOUT);
        }
        return this.needsLayout;
    }

    void setLayoutFlag(LayoutFlags flag) {
        if (this.needsLayout != null) {
            this.needsLayout.set(flag == LayoutFlags.NEEDS_LAYOUT);
        }
        this.layoutFlag = flag;
    }

    private void markDirtyLayout(boolean local) {
        this.setLayoutFlag(LayoutFlags.NEEDS_LAYOUT);
        if (local || this.layoutRoot) {
            if (this.sceneRoot) {
                Toolkit.getToolkit().requestNextPulse();
                if (this.getSubScene() != null) {
                    this.getSubScene().setDirtyLayout(this);
                }
            } else {
                this.markDirtyLayoutBranch();
            }
        } else {
            this.requestParentLayout();
        }
    }

    public void requestLayout() {
        this.clearSizeCache();
        this.markDirtyLayout(false);
    }

    protected final void requestParentLayout() {
        Parent parent;
        if (!this.layoutRoot && (parent = this.getParent()) != null && !parent.performingLayout) {
            parent.requestLayout();
        }
    }

    void clearSizeCache() {
        if (this.sizeCacheClear) {
            return;
        }
        this.sizeCacheClear = true;
        this.prefWidthCache = -1.0;
        this.prefHeightCache = -1.0;
        this.minWidthCache = -1.0;
        this.minHeightCache = -1.0;
    }

    @Override
    public double prefWidth(double height) {
        if (height == -1.0) {
            if (this.prefWidthCache == -1.0) {
                this.prefWidthCache = this.computePrefWidth(-1.0);
                if (Double.isNaN(this.prefWidthCache) || this.prefWidthCache < 0.0) {
                    this.prefWidthCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.prefWidthCache;
        }
        double result = this.computePrefWidth(height);
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    @Override
    public double prefHeight(double width) {
        if (width == -1.0) {
            if (this.prefHeightCache == -1.0) {
                this.prefHeightCache = this.computePrefHeight(-1.0);
                if (Double.isNaN(this.prefHeightCache) || this.prefHeightCache < 0.0) {
                    this.prefHeightCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.prefHeightCache;
        }
        double result = this.computePrefHeight(width);
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    @Override
    public double minWidth(double height) {
        if (height == -1.0) {
            if (this.minWidthCache == -1.0) {
                this.minWidthCache = this.computeMinWidth(-1.0);
                if (Double.isNaN(this.minWidthCache) || this.minWidthCache < 0.0) {
                    this.minWidthCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.minWidthCache;
        }
        double result = this.computeMinWidth(height);
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    @Override
    public double minHeight(double width) {
        if (width == -1.0) {
            if (this.minHeightCache == -1.0) {
                this.minHeightCache = this.computeMinHeight(-1.0);
                if (Double.isNaN(this.minHeightCache) || this.minHeightCache < 0.0) {
                    this.minHeightCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.minHeightCache;
        }
        double result = this.computeMinHeight(width);
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    protected double computePrefWidth(double height) {
        double minX = 0.0;
        double maxX = 0.0;
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isManaged()) continue;
            double x = node.getLayoutBounds().getMinX() + node.getLayoutX();
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x + this.boundedSize(node.prefWidth(-1.0), node.minWidth(-1.0), node.maxWidth(-1.0)));
        }
        return maxX - minX;
    }

    protected double computePrefHeight(double width) {
        double minY = 0.0;
        double maxY = 0.0;
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isManaged()) continue;
            double y = node.getLayoutBounds().getMinY() + node.getLayoutY();
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y + this.boundedSize(node.prefHeight(-1.0), node.minHeight(-1.0), node.maxHeight(-1.0)));
        }
        return maxY - minY;
    }

    protected double computeMinWidth(double height) {
        return this.prefWidth(height);
    }

    protected double computeMinHeight(double width) {
        return this.prefHeight(width);
    }

    @Override
    public double getBaselineOffset() {
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            double offset;
            Node child = (Node)this.children.get(i);
            if (!child.isManaged() || (offset = child.getBaselineOffset()) == Double.NEGATIVE_INFINITY) continue;
            return child.getLayoutBounds().getMinY() + child.getLayoutY() + offset;
        }
        return super.getBaselineOffset();
    }

    public final void layout() {
        switch (this.layoutFlag) {
            case CLEAN: {
                break;
            }
            case NEEDS_LAYOUT: {
                if (this.performingLayout) break;
                this.performingLayout = true;
                this.layoutChildren();
            }
            case DIRTY_BRANCH: {
                int max = this.children.size();
                for (int i = 0; i < max; ++i) {
                    Node child = (Node)this.children.get(i);
                    if (child instanceof Parent) {
                        ((Parent)child).layout();
                        continue;
                    }
                    if (!(child instanceof SubScene)) continue;
                    ((SubScene)child).layoutPass();
                }
                this.setLayoutFlag(LayoutFlags.CLEAN);
                this.performingLayout = false;
            }
        }
    }

    protected void layoutChildren() {
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isResizable() || !node.isManaged()) continue;
            node.autosize();
        }
    }

    @Override
    final void notifyManagedChanged() {
        this.layoutRoot = !this.isManaged() || this.sceneRoot;
    }

    final boolean isSceneRoot() {
        return this.sceneRoot;
    }

    public final ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    @Deprecated
    public List<String> impl_getAllParentStylesheets() {
        List<String> list = null;
        Parent myParent = this.getParent();
        if (myParent != null) {
            list = myParent.impl_getAllParentStylesheets();
        }
        if (this.stylesheets != null && !this.stylesheets.isEmpty()) {
            if (list == null) {
                list = new ArrayList<String>(this.stylesheets.size());
            }
            int nMax = this.stylesheets.size();
            for (int n = 0; n < nMax; ++n) {
                list.add((String)this.stylesheets.get(n));
            }
        }
        return list;
    }

    @Override
    @Deprecated
    protected void impl_processCSS(WritableValue<Boolean> unused) {
        if (this.cssFlag == CssFlags.CLEAN) {
            return;
        }
        if (this.cssFlag == CssFlags.DIRTY_BRANCH) {
            super.processCSS();
            return;
        }
        super.impl_processCSS(unused);
        if (this.children.isEmpty()) {
            return;
        }
        Node[] childArray = this.children.toArray(new Node[this.children.size()]);
        for (int i = 0; i < childArray.length; ++i) {
            Node child = childArray[i];
            Parent childParent = child.getParent();
            if (childParent == null || childParent != this) continue;
            if (CssFlags.UPDATE.compareTo(child.cssFlag) > 0) {
                child.cssFlag = CssFlags.UPDATE;
            }
            child.impl_processCSS(unused);
        }
    }

    protected Parent() {
        this.layoutFlag = LayoutFlags.NEEDS_LAYOUT;
        this.setAccessibleRole(AccessibleRole.PARENT);
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        return new NGGroup();
    }

    @Override
    void nodeResolvedOrientationChanged() {
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            ((Node)this.children.get(i)).parentResolvedOrientationInvalidated();
        }
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        if (this.children.isEmpty()) {
            return bounds.makeEmpty();
        }
        if (tx.isTranslateOrIdentity()) {
            if (this.cachedBoundsInvalid) {
                this.recomputeBounds();
                if (this.dirtyChildren != null) {
                    this.dirtyChildren.clear();
                }
                this.cachedBoundsInvalid = false;
                this.dirtyChildrenCount = 0;
            }
            bounds = !tx.isIdentity() ? bounds.deriveWithNewBounds((float)((double)this.cachedBounds.getMinX() + tx.getMxt()), (float)((double)this.cachedBounds.getMinY() + tx.getMyt()), (float)((double)this.cachedBounds.getMinZ() + tx.getMzt()), (float)((double)this.cachedBounds.getMaxX() + tx.getMxt()), (float)((double)this.cachedBounds.getMaxY() + tx.getMyt()), (float)((double)this.cachedBounds.getMaxZ() + tx.getMzt())) : bounds.deriveWithNewBounds(this.cachedBounds);
            return bounds;
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        boolean first = true;
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isVisible() || (bounds = this.getChildTransformedBounds(node, tx, bounds)).isEmpty()) continue;
            if (first) {
                minX = bounds.getMinX();
                minY = bounds.getMinY();
                minZ = bounds.getMinZ();
                maxX = bounds.getMaxX();
                maxY = bounds.getMaxY();
                maxZ = bounds.getMaxZ();
                first = false;
                continue;
            }
            minX = Math.min((double)bounds.getMinX(), minX);
            minY = Math.min((double)bounds.getMinY(), minY);
            minZ = Math.min((double)bounds.getMinZ(), minZ);
            maxX = Math.max((double)bounds.getMaxX(), maxX);
            maxY = Math.max((double)bounds.getMaxY(), maxY);
            maxZ = Math.max((double)bounds.getMaxZ(), maxZ);
        }
        if (first) {
            bounds.makeEmpty();
        } else {
            bounds = bounds.deriveWithNewBounds((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ);
        }
        return bounds;
    }

    private void setChildDirty(Node node, boolean dirty) {
        if (node.boundsChanged == dirty) {
            return;
        }
        node.boundsChanged = dirty;
        if (dirty) {
            if (this.dirtyChildren != null) {
                this.dirtyChildren.add(node);
            }
            ++this.dirtyChildrenCount;
        } else {
            if (this.dirtyChildren != null) {
                this.dirtyChildren.remove(node);
            }
            --this.dirtyChildrenCount;
        }
    }

    private void childIncluded(Node node) {
        this.cachedBoundsInvalid = true;
        this.setChildDirty(node, true);
    }

    private void childExcluded(Node node) {
        if (node == this.left) {
            this.left = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.top) {
            this.top = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.near) {
            this.near = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.right) {
            this.right = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.bottom) {
            this.bottom = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.far) {
            this.far = null;
            this.cachedBoundsInvalid = true;
        }
        this.setChildDirty(node, false);
    }

    private void recomputeBounds() {
        if (this.children.isEmpty()) {
            this.cachedBounds.makeEmpty();
            return;
        }
        if (this.children.size() == 1) {
            Node node = (Node)this.children.get(0);
            node.boundsChanged = false;
            if (node.isVisible()) {
                this.cachedBounds = this.getChildTransformedBounds(node, BaseTransform.IDENTITY_TRANSFORM, this.cachedBounds);
                this.near = this.far = node;
                this.right = this.far;
                this.bottom = this.far;
                this.left = this.far;
                this.top = this.far;
            } else {
                this.cachedBounds.makeEmpty();
            }
            return;
        }
        if (this.dirtyChildrenCount == 0 || !this.updateCachedBounds(this.dirtyChildren != null ? this.dirtyChildren : this.children, this.dirtyChildrenCount)) {
            this.createCachedBounds(this.children);
        }
    }

    private boolean updateCachedBounds(List<Node> dirtyNodes, int remainingDirtyNodes) {
        if (this.cachedBounds.isEmpty()) {
            this.createCachedBounds(dirtyNodes);
            return true;
        }
        int invalidEdges = 0;
        if (this.left == null || this.left.boundsChanged) {
            invalidEdges |= 1;
        }
        if (this.top == null || this.top.boundsChanged) {
            invalidEdges |= 2;
        }
        if (this.near == null || this.near.boundsChanged) {
            invalidEdges |= 4;
        }
        if (this.right == null || this.right.boundsChanged) {
            invalidEdges |= 8;
        }
        if (this.bottom == null || this.bottom.boundsChanged) {
            invalidEdges |= 0x10;
        }
        if (this.far == null || this.far.boundsChanged) {
            invalidEdges |= 0x20;
        }
        float minX = this.cachedBounds.getMinX();
        float minY = this.cachedBounds.getMinY();
        float minZ = this.cachedBounds.getMinZ();
        float maxX = this.cachedBounds.getMaxX();
        float maxY = this.cachedBounds.getMaxY();
        float maxZ = this.cachedBounds.getMaxZ();
        int i = dirtyNodes.size() - 1;
        while (remainingDirtyNodes > 0) {
            Node node = dirtyNodes.get(i);
            if (node.boundsChanged) {
                node.boundsChanged = false;
                --remainingDirtyNodes;
                this.tmp = this.getChildTransformedBounds(node, BaseTransform.IDENTITY_TRANSFORM, this.tmp);
                if (!this.tmp.isEmpty()) {
                    float tmpx = this.tmp.getMinX();
                    float tmpy = this.tmp.getMinY();
                    float tmpz = this.tmp.getMinZ();
                    float tmpx2 = this.tmp.getMaxX();
                    float tmpy2 = this.tmp.getMaxY();
                    float tmpz2 = this.tmp.getMaxZ();
                    if (tmpx <= minX) {
                        minX = tmpx;
                        this.left = node;
                        invalidEdges &= 0xFFFFFFFE;
                    }
                    if (tmpy <= minY) {
                        minY = tmpy;
                        this.top = node;
                        invalidEdges &= 0xFFFFFFFD;
                    }
                    if (tmpz <= minZ) {
                        minZ = tmpz;
                        this.near = node;
                        invalidEdges &= 0xFFFFFFFB;
                    }
                    if (tmpx2 >= maxX) {
                        maxX = tmpx2;
                        this.right = node;
                        invalidEdges &= 0xFFFFFFF7;
                    }
                    if (tmpy2 >= maxY) {
                        maxY = tmpy2;
                        this.bottom = node;
                        invalidEdges &= 0xFFFFFFEF;
                    }
                    if (tmpz2 >= maxZ) {
                        maxZ = tmpz2;
                        this.far = node;
                        invalidEdges &= 0xFFFFFFDF;
                    }
                }
            }
            --i;
        }
        if (invalidEdges != 0) {
            return false;
        }
        this.cachedBounds = this.cachedBounds.deriveWithNewBounds(minX, minY, minZ, maxX, maxY, maxZ);
        return true;
    }

    private void createCachedBounds(List<Node> fromNodes) {
        Node node;
        int i;
        int nodeCount = fromNodes.size();
        for (i = 0; i < nodeCount; ++i) {
            node = fromNodes.get(i);
            node.boundsChanged = false;
            if (!node.isVisible()) continue;
            this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
            if (this.tmp.isEmpty()) continue;
            this.bottom = this.far = node;
            this.right = this.far;
            this.near = this.far;
            this.top = this.far;
            this.left = this.far;
            break;
        }
        if (i == nodeCount) {
            this.far = null;
            this.bottom = null;
            this.right = null;
            this.near = null;
            this.top = null;
            this.left = null;
            this.cachedBounds.makeEmpty();
            return;
        }
        float minX = this.tmp.getMinX();
        float minY = this.tmp.getMinY();
        float minZ = this.tmp.getMinZ();
        float maxX = this.tmp.getMaxX();
        float maxY = this.tmp.getMaxY();
        float maxZ = this.tmp.getMaxZ();
        ++i;
        while (i < nodeCount) {
            node = fromNodes.get(i);
            node.boundsChanged = false;
            if (node.isVisible()) {
                this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
                if (!this.tmp.isEmpty()) {
                    float tmpx = this.tmp.getMinX();
                    float tmpy = this.tmp.getMinY();
                    float tmpz = this.tmp.getMinZ();
                    float tmpx2 = this.tmp.getMaxX();
                    float tmpy2 = this.tmp.getMaxY();
                    float tmpz2 = this.tmp.getMaxZ();
                    if (tmpx < minX) {
                        minX = tmpx;
                        this.left = node;
                    }
                    if (tmpy < minY) {
                        minY = tmpy;
                        this.top = node;
                    }
                    if (tmpz < minZ) {
                        minZ = tmpz;
                        this.near = node;
                    }
                    if (tmpx2 > maxX) {
                        maxX = tmpx2;
                        this.right = node;
                    }
                    if (tmpy2 > maxY) {
                        maxY = tmpy2;
                        this.bottom = node;
                    }
                    if (tmpz2 > maxZ) {
                        maxZ = tmpz2;
                        this.far = node;
                    }
                }
            }
            ++i;
        }
        this.cachedBounds = this.cachedBounds.deriveWithNewBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    protected void updateBounds() {
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            ((Node)this.children.get(i)).updateBounds();
        }
        super.updateBounds();
    }

    private BaseBounds getChildTransformedBounds(Node node, BaseTransform tx, BaseBounds bounds) {
        this.currentlyProcessedChild = node;
        bounds = node.getTransformedBounds(bounds, tx);
        this.currentlyProcessedChild = null;
        return bounds;
    }

    void childBoundsChanged(Node node) {
        if (node == this.currentlyProcessedChild) {
            return;
        }
        this.cachedBoundsInvalid = true;
        this.setChildDirty(node, true);
        this.impl_geomChanged();
    }

    void childVisibilityChanged(Node node) {
        if (node.isVisible()) {
            this.childIncluded(node);
        } else {
            this.childExcluded(node);
        }
        this.impl_geomChanged();
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double localX, double localY) {
        Point2D tempPt = TempState.getInstance().point;
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)this.children.get(i);
            tempPt.x = (float)localX;
            tempPt.y = (float)localY;
            try {
                node.parentToLocal(tempPt);
            }
            catch (NoninvertibleTransformException e) {
                continue;
            }
            if (!node.contains(tempPt.x, tempPt.y)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm alg, MXNodeAlgorithmContext ctx) {
        return alg.processContainerNode(this, ctx);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case CHILDREN: {
                return this.getChildrenUnmodifiable();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    void releaseAccessible() {
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)this.children.get(i);
            node.releaseAccessible();
        }
        super.releaseAccessible();
    }

    List<Node> test_getRemoved() {
        return this.removed;
    }
}

