/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.beans.NamedArg;
import javafx.scene.image.Image;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;

public final class BackgroundImage {
    final Image image;
    final BackgroundRepeat repeatX;
    final BackgroundRepeat repeatY;
    final BackgroundPosition position;
    final BackgroundSize size;
    Boolean opaque = null;
    private final int hash;

    public final Image getImage() {
        return this.image;
    }

    public final BackgroundRepeat getRepeatX() {
        return this.repeatX;
    }

    public final BackgroundRepeat getRepeatY() {
        return this.repeatY;
    }

    public final BackgroundPosition getPosition() {
        return this.position;
    }

    public final BackgroundSize getSize() {
        return this.size;
    }

    public BackgroundImage(@NamedArg(value="image") Image image, @NamedArg(value="repeatX") BackgroundRepeat repeatX, @NamedArg(value="repeatY") BackgroundRepeat repeatY, @NamedArg(value="position") BackgroundPosition position, @NamedArg(value="size") BackgroundSize size) {
        if (image == null) {
            throw new NullPointerException("Image cannot be null");
        }
        this.image = image;
        this.repeatX = repeatX == null ? BackgroundRepeat.REPEAT : repeatX;
        this.repeatY = repeatY == null ? BackgroundRepeat.REPEAT : repeatY;
        this.position = position == null ? BackgroundPosition.DEFAULT : position;
        this.size = size == null ? BackgroundSize.DEFAULT : size;
        int result = this.image.hashCode();
        result = 31 * result + this.repeatX.hashCode();
        result = 31 * result + this.repeatY.hashCode();
        result = 31 * result + this.position.hashCode();
        this.hash = result = 31 * result + this.size.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundImage that = (BackgroundImage)o;
        if (this.hash != that.hash) {
            return false;
        }
        if (!this.image.equals(that.image)) {
            return false;
        }
        if (!this.position.equals(that.position)) {
            return false;
        }
        if (this.repeatX != that.repeatX) {
            return false;
        }
        if (this.repeatY != that.repeatY) {
            return false;
        }
        return this.size.equals(that.size);
    }

    public int hashCode() {
        return this.hash;
    }
}

