/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.util;

import org.openimaj.audio.timecode.MeasuresBeatsTicksTimecode;
import org.openimaj.time.TimeKeeper;

public class BasicMusicTimekeeper
implements TimeKeeper<MeasuresBeatsTicksTimecode> {
    private long lastStarted;
    private long timeOffset;
    private long pausedAt;
    private boolean isRunning;
    private long currentTime;
    private MeasuresBeatsTicksTimecode timecode = new MeasuresBeatsTicksTimecode(120.0f, 0L, 0, 0, 4);

    public void setBPM(float bpm) {
        this.timecode = new MeasuresBeatsTicksTimecode(bpm, this.timecode.getMeasures(), this.timecode.getBeats(), this.timecode.getTicks(), this.timecode.beatsPerMeasure);
    }

    public double getBPM() {
        return this.timecode.bpm;
    }

    public void run() {
        if (this.lastStarted == 0L) {
            this.lastStarted = System.currentTimeMillis();
        } else if (this.supportsPause()) {
            this.timeOffset += System.currentTimeMillis() - this.pausedAt;
        }
        this.isRunning = true;
    }

    public void pause() {
        if (this.supportsPause()) {
            this.isRunning = false;
            this.pausedAt = System.currentTimeMillis();
        }
    }

    public void stop() {
        this.isRunning = false;
        this.currentTime = 0L;
    }

    public MeasuresBeatsTicksTimecode getTime() {
        if (this.isRunning) {
            this.currentTime = System.currentTimeMillis() - this.lastStarted - this.timeOffset;
            this.timecode.setTimecodeInMilliseconds(this.currentTime);
        }
        return this.timecode;
    }

    public void seek(long timestamp) {
    }

    public void reset() {
        this.lastStarted = 0L;
        this.pausedAt = -1L;
        this.run();
    }

    public boolean supportsPause() {
        return true;
    }

    public boolean supportsSeek() {
        return false;
    }

    public int getTicksPerBeat() {
        return this.timecode.ticksPerBeat;
    }
}

