/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.statistics.distribution.MultivariateGaussian;
import org.openimaj.math.util.QuadraticEquation;

public class EllipseUtilities {
    public static Ellipse ellipseFromEquation(double centerX, double centerY, double major, double minor, double rotation) {
        return new Ellipse(centerX, centerY, major, minor, rotation);
    }

    public static Ellipse ellipseFromSecondMoments(float x, float y, Matrix secondMoments) {
        return EllipseUtilities.ellipseFromSecondMoments(x, y, secondMoments, 1.0);
    }

    public static Ellipse ellipseFromSecondMoments(float x, float y, Matrix secondMoments, double scaleFactor) {
        double divFactor = 1.0 / Math.sqrt(secondMoments.det());
        EigenvalueDecomposition rdr = secondMoments.times(divFactor).eig();
        double d1 = rdr.getD().get(0, 0) == 0.0 ? 0.0 : 1.0 / Math.sqrt(rdr.getD().get(0, 0));
        double d2 = rdr.getD().get(1, 1) == 0.0 ? 0.0 : 1.0 / Math.sqrt(rdr.getD().get(1, 1));
        double scaleCorrectedD1 = d1 * scaleFactor;
        double scaleCorrectedD2 = d2 * scaleFactor;
        Matrix eigenMatrix = rdr.getV();
        double rotation = Math.atan2(eigenMatrix.get(1, 0), eigenMatrix.get(0, 0));
        return EllipseUtilities.ellipseFromEquation(x, y, scaleCorrectedD1, scaleCorrectedD2, rotation);
    }

    public static Ellipse ellipseFromCovariance(float x, float y, Matrix sm, float sf) {
        double xy = sm.get(1, 0);
        double xx = sm.get(0, 0);
        double yy = sm.get(1, 1);
        double theta = 0.5 * Math.atan2(2.0 * xy, xx - yy);
        double trace = xx + yy;
        double det = xx * yy - xy * xy;
        double[] eigval = QuadraticEquation.solveGeneralQuadratic(1.0, -trace, det);
        double a = Math.sqrt(eigval[1]) * (double)sf;
        double b = Math.sqrt(eigval[0]) * (double)sf;
        return EllipseUtilities.ellipseFromEquation(x, y, a, b, theta);
    }

    public static Matrix ellipseToCovariance(Ellipse e) {
        Matrix transform = e.transformMatrix();
        Matrix Q = transform.getMatrix(0, 1, 0, 1);
        return Q.times(Q.transpose());
    }

    public static Ellipse fromTransformMatrix2x2(Matrix U, float x, float y, float scale) {
        EigenvalueDecomposition ueig = U.eig();
        Matrix uVal = ueig.getD();
        Matrix uVec = ueig.getV();
        double uval1 = uVal.get(0, 0);
        double uval2 = uVal.get(1, 1);
        if (Math.abs(uval1) < Math.abs(uval2)) {
            uVal.set(0, 0, 1.0);
            uVal.set(1, 1, uval2 / uval1);
        } else {
            uVal.set(1, 1, 1.0);
            uVal.set(0, 0, uval1 / uval2);
        }
        float ax1 = (float)(1.0 / Math.abs(uVal.get(1, 1)) * (double)scale);
        float ax2 = (float)(1.0 / Math.abs(uVal.get(0, 0)) * (double)scale);
        double phi = Math.atan(uVec.get(1, 1) / uVec.get(0, 1));
        return new Ellipse(x, y, ax1, ax2, phi);
    }

    public static Ellipse ellipseFromGaussian(MultivariateGaussian gaussian, float scale) {
        Matrix mean = gaussian.getMean();
        float x = (float)mean.get(0, 0);
        float y = (float)mean.get(0, 1);
        Matrix covar = gaussian.getCovariance();
        return EllipseUtilities.ellipseFromCovariance(x, y, covar, scale);
    }
}

