/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms;

import Jama.Matrix;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.MatrixTransformProvider;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.matrix.MatrixUtils;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.util.function.Predicate;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class HomographyModel
implements EstimatableModel<Point2d, Point2d>,
MatrixTransformProvider {
    protected Predicate<HomographyModel> modelCheck;
    protected Matrix homography = Matrix.identity((int)3, (int)3);
    protected boolean normalise;

    public HomographyModel() {
        this(true);
    }

    public HomographyModel(boolean norm) {
        this.normalise = norm;
    }

    public HomographyModel(Predicate<HomographyModel> mc) {
        this(true, mc);
    }

    public HomographyModel(boolean norm, Predicate<HomographyModel> mc) {
        this.normalise = norm;
        this.modelCheck = mc;
    }

    public HomographyModel clone() {
        HomographyModel hm = new HomographyModel(this.normalise);
        hm.homography = this.homography.copy();
        return hm;
    }

    @Override
    public Matrix getTransform() {
        return this.homography;
    }

    public void setTransform(Matrix matrix) {
        this.homography = matrix;
    }

    @Override
    public boolean estimate(List<? extends IndependentPair<Point2d, Point2d>> data) {
        this.homography = this.normalise ? TransformUtilities.homographyMatrixNorm(data) : TransformUtilities.homographyMatrix(data);
        if (this.modelCheck == null) {
            return true;
        }
        return this.modelCheck.test((Object)this);
    }

    public void denormaliseHomography(Pair<Matrix> normalisations) {
        this.homography = ((Matrix)normalisations.secondObject()).inverse().times(this.homography).times((Matrix)normalisations.firstObject());
        if (Math.abs(this.homography.get(2, 2)) > 1.0E-6) {
            MatrixUtils.times(this.homography, 1.0 / this.homography.get(2, 2));
        }
    }

    @Override
    public int numItemsToEstimate() {
        return 4;
    }

    @Override
    public Point2d predict(Point2d data) {
        return data.transform(this.homography);
    }
}

