/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms.estimation;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.FundamentalModel;
import org.openimaj.math.geometry.transforms.FundamentalRefinement;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.geometry.transforms.estimation.sampling.BucketingSampler2d;
import org.openimaj.math.model.fit.LMedS;
import org.openimaj.math.model.fit.RANSAC;
import org.openimaj.math.model.fit.RobustModelFitting;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class RobustFundamentalEstimator
implements RobustModelFitting<Point2d, Point2d, FundamentalModel> {
    private RobustModelFitting<Point2d, Point2d, FundamentalModel> robustFitter;
    private FundamentalRefinement refinement;
    List<IndependentPair<Point2d, Point2d>> inliers = new ArrayList<IndependentPair<Point2d, Point2d>>();
    List<IndependentPair<Point2d, Point2d>> outliers = new ArrayList<IndependentPair<Point2d, Point2d>>();

    public RobustFundamentalEstimator(double outlierProportion, FundamentalRefinement refinement) {
        this.robustFitter = new LMedS<Point2d, Point2d, FundamentalModel>(new FundamentalModel(false), new FundamentalModel.Fundamental8PtResidual(), outlierProportion, true, new BucketingSampler2d());
        this.refinement = refinement;
    }

    public RobustFundamentalEstimator(double threshold, int nIterations, RANSAC.StoppingCondition stoppingCondition, FundamentalRefinement refinement) {
        this.robustFitter = new RANSAC<Point2d, Point2d, FundamentalModel>(new FundamentalModel(false), new FundamentalModel.Fundamental8PtResidual(), threshold, nIterations, stoppingCondition, true, new BucketingSampler2d());
        this.refinement = refinement;
    }

    @Override
    public boolean fitData(List<? extends IndependentPair<Point2d, Point2d>> data) {
        Pair<Matrix> norms = TransformUtilities.getNormalisations(data);
        List<? extends IndependentPair<Point2d, Point2d>> normData = TransformUtilities.normalise(data, norms);
        if (!this.robustFitter.fitData(normData)) {
            ((FundamentalModel)this.robustFitter.getModel()).estimate(normData);
            ((FundamentalModel)this.robustFitter.getModel()).denormaliseFundamental(norms);
            return false;
        }
        this.inliers.clear();
        for (IndependentPair<Point2d, Point2d> pair : this.robustFitter.getInliers()) {
            this.inliers.add(data.get(normData.indexOf(pair)));
        }
        this.outliers.clear();
        for (IndependentPair<Point2d, Point2d> pair : this.robustFitter.getOutliers()) {
            this.outliers.add(data.get(normData.indexOf(pair)));
        }
        ((FundamentalModel)this.robustFitter.getModel()).denormaliseFundamental(norms);
        Matrix optimised = this.refinement.refine(((FundamentalModel)this.robustFitter.getModel()).getF(), this.inliers);
        ((FundamentalModel)this.robustFitter.getModel()).setF(optimised);
        return true;
    }

    @Override
    public int numItemsToEstimate() {
        return this.robustFitter.numItemsToEstimate();
    }

    @Override
    public FundamentalModel getModel() {
        return (FundamentalModel)this.robustFitter.getModel();
    }

    @Override
    public List<? extends IndependentPair<Point2d, Point2d>> getInliers() {
        return this.inliers;
    }

    @Override
    public List<? extends IndependentPair<Point2d, Point2d>> getOutliers() {
        return this.outliers;
    }
}

