/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class Geom {
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int EAST = 4;

    private Geom() {
    }

    public static boolean lineContainsPoint(int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = new Rectangle(new Point(n, n2));
        rectangle.add(n3, n4);
        rectangle.grow(2, 2);
        if (!rectangle.contains(n5, n6)) {
            return false;
        }
        if (n == n3) {
            return Math.abs(n5 - n) < 3;
        }
        if (n2 == n4) {
            return Math.abs(n6 - n2) < 3;
        }
        double d = (n2 - n4) / (n - n3);
        double d2 = (double)n2 - d * (double)n;
        double d3 = ((double)n6 - d2) / d;
        double d4 = d * (double)n5 + d2;
        return Math.min(Math.abs(d3 - (double)n5), Math.abs(d4 - (double)n6)) < 4.0;
    }

    public static int direction(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n4 - n2;
        int n7 = n3 - n;
        n5 = n6 < n7 && n7 > -n6 ? 4 : (n6 > n7 && n6 > -n7 ? 1 : (n7 < n6 && n7 < -n6 ? 3 : 2));
        return n5;
    }

    public static Point south(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
    }

    public static Point center(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public static Point west(Rectangle rectangle) {
        return new Point(rectangle.x, rectangle.y + rectangle.height / 2);
    }

    public static Point east(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
    }

    public static Point north(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y);
    }

    public static Point corner(Rectangle rectangle) {
        return new Point((int)rectangle.getMaxX(), (int)rectangle.getMaxY());
    }

    public static Point topLeftCorner(Rectangle rectangle) {
        return rectangle.getLocation();
    }

    public static Point topRightCorner(Rectangle rectangle) {
        return new Point((int)rectangle.getMaxX(), (int)rectangle.getMinY());
    }

    public static Point bottomLeftCorner(Rectangle rectangle) {
        return new Point((int)rectangle.getMinX(), (int)rectangle.getMaxY());
    }

    public static Point bottomRightCorner(Rectangle rectangle) {
        return Geom.corner(rectangle);
    }

    public static int range(int n, int n2, int n3) {
        if (n3 < n) {
            n3 = n;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    public static long length2(int n, int n2, int n3, int n4) {
        return (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2);
    }

    public static long length(int n, int n2, int n3, int n4) {
        return (long)Math.sqrt(Geom.length2(n, n2, n3, n4));
    }

    public static double pointToAngle(Rectangle rectangle, Point point) {
        int n = point.x - (rectangle.x + rectangle.width / 2);
        int n2 = point.y - (rectangle.y + rectangle.height / 2);
        return Math.atan2(n2 * rectangle.width, n * rectangle.height);
    }

    public static Point angleToPoint(Rectangle rectangle, double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 1.0E-4;
        int n = 0;
        int n2 = 0;
        if (Math.abs(d2) > d4) {
            n = (int)((1.0 + d3 / Math.abs(d2)) / 2.0 * (double)rectangle.width);
            n = Geom.range(0, rectangle.width, n);
        } else if (d3 >= 0.0) {
            n = rectangle.width;
        }
        if (Math.abs(d3) > d4) {
            n2 = (int)((1.0 + d2 / Math.abs(d3)) / 2.0 * (double)rectangle.height);
            n2 = Geom.range(0, rectangle.height, n2);
        } else if (d2 >= 0.0) {
            n2 = rectangle.height;
        }
        return new Point(rectangle.x + n, rectangle.y + n2);
    }

    public static Point polarToPoint(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        return new Point((int)(d2 * d5 + 0.5), (int)(d3 * d4 + 0.5));
    }

    public static Point ovalAngleToPoint(Rectangle rectangle, double d) {
        Point point = Geom.center(rectangle);
        Point point2 = Geom.polarToPoint(d, rectangle.width / 2, rectangle.height / 2);
        return new Point(point.x + point2.x, point.y + point2.y);
    }

    public static Point intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        double d = (n3 - n) * (n8 - n6) - (n4 - n2) * (n7 - n5);
        double d2 = (n2 - n6) * (n7 - n5) - (n - n5) * (n8 - n6);
        if (d == 0.0) {
            if (d2 == 0.0) {
                if (n < n3 && (n3 < n5 || n3 < n7) || n > n3 && (n3 > n5 || n3 > n7)) {
                    return new Point(n3, n4);
                }
                return new Point(n, n2);
            }
            return null;
        }
        double d3 = d2 / d;
        double d4 = (n2 - n6) * (n3 - n) - (n - n5) * (n4 - n2);
        double d5 = d4 / d;
        if (0.0 <= d3 && d3 <= 1.0 && 0.0 <= d5 && d5 <= 1.0) {
            int n9 = (int)((double)n + (double)(n3 - n) * d3);
            int n10 = (int)((double)n2 + (double)(n4 - n2) * d3);
            return new Point(n9, n10);
        }
        return null;
    }

    public static double distanceFromLine(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 - n;
        int n8 = n4 - n2;
        long l = n7 * n7 + n8 * n8;
        if (l == 0L) {
            return Geom.length(n, n2, n5, n6);
        }
        double d = (n2 - n6) * (n2 - n4) - (n - n5) * (n3 - n);
        double d2 = d / (double)l;
        if (d2 < 0.0 || d2 > 1.0) {
            return Double.MAX_VALUE;
        }
        double d3 = (double)n + d2 * (double)n7;
        double d4 = (double)n2 + d2 * (double)n8;
        double d5 = (double)n5 - d3;
        double d6 = (double)n6 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public static double distanceFromLine2D(int n, int n2, int n3, int n4, int n5, int n6) {
        Line2D.Double double_ = new Line2D.Double(n, n3, n2, n4);
        return double_.ptSegDist(n5, n6);
    }
}

