/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io;

import cern.colt.Arrays;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.io.Cachable;
import org.openimaj.io.CachableASCII;
import org.openimaj.io.FileUtils;
import org.openimaj.io.IOUtils;
import org.openimaj.io.ReadWriteableASCII;
import org.openimaj.io.ReadWriteableBinary;

public class Cache {
    private static final String cacheProp = "org.openimaj.cache.dir";
    private static final String CACHE_DIR_NAME = ".OIcache";

    public static <T> T load(T instance) {
        T ret = Cache.load(instance, instance.getClass(), false);
        return ret;
    }

    public static <T> T load(Class<? extends T> clazz, Object ... objects) {
        return Cache.load(clazz, false, objects);
    }

    public static <T> T loadSkipCache(Class<? extends T> clazz, Object ... objects) {
        return Cache.load(clazz, true, objects);
    }

    public static <T extends Cachable> void clear(Class<T> clazz, Object ... objects) {
        Cachable instance = (Cachable)Cache.createInstance(clazz, objects);
        File location = Cache.constructCachedLocation(instance, clazz);
        FileUtils.deleteRecursive(location);
    }

    public static void clear(Cachable instance) {
        File location = Cache.constructCachedLocation(instance, instance.getClass());
        FileUtils.deleteRecursive(location);
    }

    private static <T> T load(Class<? extends T> clazz, boolean skipcache, Object ... objects) {
        T instance = Cache.createInstance(clazz, objects);
        return Cache.load(instance, clazz, skipcache);
    }

    public static <T> T load(T instance, Class<? extends T> clazz, boolean skipcache) {
        if (instance instanceof Cachable && !skipcache) {
            Cachable cinstance = (Cachable)instance;
            File cachedLocation = Cache.constructCachedLocation(cinstance, clazz);
            try {
                if (cachedLocation.exists()) {
                    if (cinstance instanceof ReadWriteableASCII) {
                        ReadWriteableASCII rwinstance = Cache.cacheFromASCII((ReadWriteableASCII)((Object)cinstance), cachedLocation);
                        instance = rwinstance;
                    } else if (cinstance instanceof ReadWriteableBinary) {
                        ReadWriteableBinary rwinstance = Cache.cacheFromBinary((ReadWriteableBinary)((Object)cinstance), cachedLocation);
                        instance = rwinstance;
                    }
                } else {
                    if (!cachedLocation.getParentFile().exists() && !cachedLocation.getParentFile().mkdirs()) {
                        throw new IOException("Couldn't create cache directory!");
                    }
                    if (cinstance instanceof ReadWriteableASCII) {
                        IOUtils.writeASCII(cachedLocation, (ReadWriteableASCII)instance);
                    } else if (cinstance instanceof ReadWriteableBinary) {
                        IOUtils.writeBinary(cachedLocation, (ReadWriteableBinary)instance);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error reading or writing object from cache");
            }
        }
        return instance;
    }

    private static File constructCachedLocation(Cachable cinstance, Class<?> clazz) {
        String cdir = System.getProperty(cacheProp);
        if (cdir == null || cdir.equals("")) {
            cdir = System.getProperty("user.home") + "/" + CACHE_DIR_NAME;
        }
        String pname = clazz.getPackage().getName();
        String cname = clazz.getName();
        String uname = cinstance.identifier();
        File cachedLocation = new File(cdir, String.format("%s/%s/%s", pname, cname, uname));
        return cachedLocation;
    }

    private static <T> T createInstance(Class<T> clazz, Object ... objects) {
        Object[] classes = new Class[objects.length];
        int i = 0;
        for (Object object : objects) {
            classes[i++] = object.getClass();
        }
        T instance = null;
        try {
            instance = clazz.getConstructor((Class<?>[])classes).newInstance(objects);
        }
        catch (Exception e) {
            System.err.format("Error finding constructor for class %s with classes %s\n", clazz.toString(), Arrays.toString((Object[])classes));
        }
        return instance;
    }

    private static <T extends ReadWriteableASCII> T cacheFromASCII(T rwascii, File f) throws IOException {
        return (T)((ReadWriteableASCII)((Object)IOUtils.read(f, rwascii.getClass())));
    }

    private static <T extends ReadWriteableBinary> T cacheFromBinary(T rwbin, File f) throws IOException {
        return (T)((ReadWriteableBinary)((Object)IOUtils.read(f, rwbin.getClass())));
    }

    public static void main(String[] args) {
        String a = Cache.load(String.class, "wang");
        System.out.println("This is the created string: " + a);
        CachableStringInteger csi = Cache.load(CachableStringInteger.class, 1, "wang");
        System.out.println("Got this from the cache.create():" + csi);
    }

    static class CachableStringInteger
    implements CachableASCII {
        int integer;
        String string;

        public CachableStringInteger() {
        }

        public CachableStringInteger(Integer integer, String string) {
            this.integer = integer;
            this.string = string;
        }

        @Override
        public void readASCII(Scanner in) throws IOException {
            this.integer = Integer.parseInt(in.nextLine());
            this.string = in.nextLine();
        }

        @Override
        public String asciiHeader() {
            return "STRING_INT\n";
        }

        @Override
        public void writeASCII(PrintWriter out) throws IOException {
            out.println(this.integer);
            out.println(this.string);
        }

        @Override
        public String identifier() {
            return String.format("%d-%s", this.integer, this.string);
        }

        public String toString() {
            return this.identifier();
        }
    }
}

