/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseFloatArray;

public class SparseBinSearchFloatArray
extends SparseFloatArray {
    protected int[] keys;
    protected float[] values;
    protected int used;

    public SparseBinSearchFloatArray(float[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0f) continue;
            this.set(i, values[i]);
        }
    }

    public SparseBinSearchFloatArray(int length, int used, int[] keys, float[] values) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (length < values.length) {
            throw new IllegalArgumentException("length is shorter than number of current values!");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Number of keys does not match number of values.");
        }
        this.length = length;
        this.used = used;
        this.keys = keys;
        this.values = values;
    }

    public SparseBinSearchFloatArray(int length) {
        this(length, 10);
    }

    public SparseBinSearchFloatArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.keys = new int[capacity];
        this.values = new float[capacity];
    }

    public SparseBinSearchFloatArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.keys = new int[capacity];
        this.values = new float[capacity];
    }

    @Override
    public int[] indices() {
        return Arrays.copyOf(this.keys, this.used);
    }

    @Override
    public float[] values() {
        return Arrays.copyOf(this.values, this.used);
    }

    @Override
    public Iterable<SparseFloatArray.DualEntry> unionEntries(SparseFloatArray otherArray) {
        if (otherArray instanceof SparseBinSearchFloatArray) {
            return this.unionEntries((SparseBinSearchFloatArray)otherArray);
        }
        return super.unionEntries(otherArray);
    }

    public Iterable<SparseFloatArray.DualEntry> unionEntries(final SparseBinSearchFloatArray otherArray) {
        return new Iterable<SparseFloatArray.DualEntry>(){

            @Override
            public Iterator<SparseFloatArray.DualEntry> iterator() {
                return new Iterator<SparseFloatArray.DualEntry>(){
                    private SparseFloatArray.DualEntry entry = new SparseFloatArray.DualEntry();
                    private int innerIndex = 0;
                    private int otherInnerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchFloatArray.this.used || this.otherInnerIndex < otherArray.used;
                    }

                    @Override
                    public SparseFloatArray.DualEntry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (this.innerIndex < SparseBinSearchFloatArray.this.used && (this.otherInnerIndex >= otherArray.used || SparseBinSearchFloatArray.this.keys[this.innerIndex] < otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = SparseBinSearchFloatArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchFloatArray.this.values[this.innerIndex];
                            this.entry.otherValue = 0.0f;
                            ++this.innerIndex;
                        } else if (this.otherInnerIndex < otherArray.used && (this.innerIndex >= SparseBinSearchFloatArray.this.used || SparseBinSearchFloatArray.this.keys[this.innerIndex] > otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = otherArray.keys[this.otherInnerIndex];
                            this.entry.value = 0.0f;
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.otherInnerIndex;
                        } else {
                            this.entry.index = SparseBinSearchFloatArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchFloatArray.this.values[this.innerIndex];
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.innerIndex;
                            ++this.otherInnerIndex;
                        }
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<SparseFloatArray.Entry> entries() {
        return new Iterable<SparseFloatArray.Entry>(){

            @Override
            public Iterator<SparseFloatArray.Entry> iterator() {
                return new Iterator<SparseFloatArray.Entry>(){
                    private SparseFloatArray.Entry entry = new SparseFloatArray.Entry();
                    private int innerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchFloatArray.this.used;
                    }

                    @Override
                    public SparseFloatArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.entry.index = SparseBinSearchFloatArray.this.keys[this.innerIndex];
                        this.entry.value = SparseBinSearchFloatArray.this.values[this.innerIndex];
                        ++this.innerIndex;
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseBinSearchFloatArray)) {
            return false;
        }
        return this.length == ((SparseBinSearchFloatArray)obj).length && this.used == ((SparseBinSearchFloatArray)obj).used && Arrays.equals(this.keys, ((SparseBinSearchFloatArray)obj).keys) && Arrays.equals(this.values, this.values);
    }

    @Override
    public float get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        return spot < 0 ? 0.0f : this.values[spot];
    }

    public int hashCode() {
        return this.length ^ Arrays.hashCode(this.keys) ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean isUsed(int key) {
        return 0 <= Arrays.binarySearch(this.keys, 0, this.used, key);
    }

    @Override
    public float set(int key, float value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            this.values[spot] = value;
            return this.values[spot];
        }
        return this.update(-1 - spot, key, value);
    }

    @Override
    public float increment(int key, float value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            int n = spot;
            float f = this.values[n] + value;
            this.values[n] = f;
            return f;
        }
        return this.update(-1 - spot, key, value);
    }

    private float update(int spot, int key, float value) {
        if (this.used == this.keys.length) {
            int capacity = this.keys.length * 3 / 2 + 1;
            this.keys = Arrays.copyOf(this.keys, capacity);
            this.values = Arrays.copyOf(this.values, capacity);
        }
        if (spot < this.used) {
            System.arraycopy(this.keys, spot, this.keys, spot + 1, this.used - spot);
            System.arraycopy(this.values, spot, this.values, spot + 1, this.used - spot);
        }
        ++this.used;
        this.keys[spot] = key;
        this.values[spot] = value;
        return this.values[spot];
    }

    @Override
    public int used() {
        return this.used;
    }

    @Override
    public void compact() {
        this.keys = Arrays.copyOf(this.keys, this.used);
        this.values = Arrays.copyOf(this.values, this.used);
    }

    @Override
    public SparseFloatArray copy() {
        SparseBinSearchFloatArray copy = new SparseBinSearchFloatArray(this.length);
        copy.used = this.used;
        copy.keys = Arrays.copyOf(this.keys, this.keys.length);
        copy.values = Arrays.copyOf(this.values, this.values.length);
        return copy;
    }

    @Override
    public SparseFloatArray reverse() {
        int len = this.used;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            float tmpVal = this.values[i];
            this.values[i] = this.values[len - i - 1];
            this.values[len - i - 1] = tmpVal;
            int tmpKey = this.keys[i];
            this.keys[i] = this.length - this.keys[len - i - 1];
            this.keys[len - i - 1] = this.length - tmpKey;
        }
        return this;
    }
}

