/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseIntArray;

public class SparseBinSearchIntArray
extends SparseIntArray {
    protected int[] keys;
    protected int[] values;
    protected int used;

    public SparseBinSearchIntArray(int[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            this.set(i, values[i]);
        }
    }

    public SparseBinSearchIntArray(int length, int used, int[] keys, int[] values) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (length < values.length) {
            throw new IllegalArgumentException("length is shorter than number of current values!");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Number of keys does not match number of values.");
        }
        this.length = length;
        this.used = used;
        this.keys = keys;
        this.values = values;
    }

    public SparseBinSearchIntArray(int length) {
        this(length, 10);
    }

    public SparseBinSearchIntArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.keys = new int[capacity];
        this.values = new int[capacity];
    }

    public SparseBinSearchIntArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.keys = new int[capacity];
        this.values = new int[capacity];
    }

    @Override
    public int[] indices() {
        return Arrays.copyOf(this.keys, this.used);
    }

    @Override
    public int[] values() {
        return Arrays.copyOf(this.values, this.used);
    }

    @Override
    public Iterable<SparseIntArray.DualEntry> unionEntries(SparseIntArray otherArray) {
        if (otherArray instanceof SparseBinSearchIntArray) {
            return this.unionEntries((SparseBinSearchIntArray)otherArray);
        }
        return super.unionEntries(otherArray);
    }

    public Iterable<SparseIntArray.DualEntry> unionEntries(final SparseBinSearchIntArray otherArray) {
        return new Iterable<SparseIntArray.DualEntry>(){

            @Override
            public Iterator<SparseIntArray.DualEntry> iterator() {
                return new Iterator<SparseIntArray.DualEntry>(){
                    private SparseIntArray.DualEntry entry = new SparseIntArray.DualEntry();
                    private int innerIndex = 0;
                    private int otherInnerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchIntArray.this.used || this.otherInnerIndex < otherArray.used;
                    }

                    @Override
                    public SparseIntArray.DualEntry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (this.innerIndex < SparseBinSearchIntArray.this.used && (this.otherInnerIndex >= otherArray.used || SparseBinSearchIntArray.this.keys[this.innerIndex] < otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = SparseBinSearchIntArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchIntArray.this.values[this.innerIndex];
                            this.entry.otherValue = 0;
                            ++this.innerIndex;
                        } else if (this.otherInnerIndex < otherArray.used && (this.innerIndex >= SparseBinSearchIntArray.this.used || SparseBinSearchIntArray.this.keys[this.innerIndex] > otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = otherArray.keys[this.otherInnerIndex];
                            this.entry.value = 0;
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.otherInnerIndex;
                        } else {
                            this.entry.index = SparseBinSearchIntArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchIntArray.this.values[this.innerIndex];
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.innerIndex;
                            ++this.otherInnerIndex;
                        }
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<SparseIntArray.Entry> entries() {
        return new Iterable<SparseIntArray.Entry>(){

            @Override
            public Iterator<SparseIntArray.Entry> iterator() {
                return new Iterator<SparseIntArray.Entry>(){
                    private SparseIntArray.Entry entry = new SparseIntArray.Entry();
                    private int innerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchIntArray.this.used;
                    }

                    @Override
                    public SparseIntArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.entry.index = SparseBinSearchIntArray.this.keys[this.innerIndex];
                        this.entry.value = SparseBinSearchIntArray.this.values[this.innerIndex];
                        ++this.innerIndex;
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseBinSearchIntArray)) {
            return false;
        }
        return this.length == ((SparseBinSearchIntArray)obj).length && this.used == ((SparseBinSearchIntArray)obj).used && Arrays.equals(this.keys, ((SparseBinSearchIntArray)obj).keys) && Arrays.equals(this.values, this.values);
    }

    @Override
    public int get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        return spot < 0 ? 0 : this.values[spot];
    }

    public int hashCode() {
        return this.length ^ Arrays.hashCode(this.keys) ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean isUsed(int key) {
        return 0 <= Arrays.binarySearch(this.keys, 0, this.used, key);
    }

    @Override
    public int set(int key, int value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            this.values[spot] = value;
            return this.values[spot];
        }
        return this.update(-1 - spot, key, value);
    }

    @Override
    public int increment(int key, int value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            int n = spot;
            int n2 = this.values[n] + value;
            this.values[n] = n2;
            return n2;
        }
        return this.update(-1 - spot, key, value);
    }

    private int update(int spot, int key, int value) {
        if (this.used == this.keys.length) {
            int capacity = this.keys.length * 3 / 2 + 1;
            this.keys = Arrays.copyOf(this.keys, capacity);
            this.values = Arrays.copyOf(this.values, capacity);
        }
        if (spot < this.used) {
            System.arraycopy(this.keys, spot, this.keys, spot + 1, this.used - spot);
            System.arraycopy(this.values, spot, this.values, spot + 1, this.used - spot);
        }
        ++this.used;
        this.keys[spot] = key;
        this.values[spot] = value;
        return this.values[spot];
    }

    @Override
    public int used() {
        return this.used;
    }

    @Override
    public void compact() {
        this.keys = Arrays.copyOf(this.keys, this.used);
        this.values = Arrays.copyOf(this.values, this.used);
    }

    @Override
    public SparseIntArray copy() {
        SparseBinSearchIntArray copy = new SparseBinSearchIntArray(this.length);
        copy.used = this.used;
        copy.keys = Arrays.copyOf(this.keys, this.keys.length);
        copy.values = Arrays.copyOf(this.values, this.values.length);
        return copy;
    }

    @Override
    public SparseIntArray reverse() {
        int len = this.used;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            int tmpVal = this.values[i];
            this.values[i] = this.values[len - i - 1];
            this.values[len - i - 1] = tmpVal;
            int tmpKey = this.keys[i];
            this.keys[i] = this.length - this.keys[len - i - 1];
            this.keys[len - i - 1] = this.length - tmpKey;
        }
        return this;
    }
}

