/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.iterator;

import java.util.Iterator;
import org.openimaj.util.iterator.NumericIterable;

public class UniformShortRangeIterable
implements NumericIterable<Short> {
    private short stop;
    private short step;
    private short current;

    public UniformShortRangeIterable(short start, short stop, short step) {
        this.stop = stop;
        this.step = step;
        this.current = start;
    }

    public UniformShortRangeIterable(short start, short stop) {
        this(start, stop, 1);
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){

            @Override
            public boolean hasNext() {
                return UniformShortRangeIterable.this.current + UniformShortRangeIterable.this.step <= UniformShortRangeIterable.this.stop;
            }

            @Override
            public Short next() {
                short ret = UniformShortRangeIterable.this.current;
                UniformShortRangeIterable.this.current = (short)(UniformShortRangeIterable.this.current + UniformShortRangeIterable.this.step);
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

