/*
 * Decompiled with CFR 0.152.
 */
package view25d.prims;

import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentSet;
import org.nlogo.api.AnonymousReporter;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.ReporterRunnable;
import org.nlogo.api.Turtle;
import org.nlogo.app.App;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import view25d.View25DExtension;
import view25d.view.TurtleView;

public class MakeTurtleView
implements Command {
    public Syntax getSyntax() {
        int[] argTypes = new int[]{Syntax.StringType(), Syntax.AgentsetType(), Syntax.ReporterType()};
        return SyntaxJ.commandSyntax((int[])argTypes, (String)"O---");
    }

    public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
        String title = args[0].getString().trim();
        if (title.length() == 0) {
            throw new ExtensionException("Window title cannot be empty.\nThis is the identifier for your window");
        }
        AgentSet as = args[1].getAgentSet();
        AnonymousReporter turtleReporter = args[2].getReporter();
        try {
            for (Agent a : as.agents()) {
                Turtle turtle = (Turtle)a;
                turtleReporter.report(context, new Object[]{turtle});
            }
        }
        catch (Exception e1) {
            throw new ExtensionException("Error in processing your reporter. " + e1);
        }
        context.workspace().updateUI();
        TurtleView newTurtleView = (TurtleView)context.workspace().waitForResult((ReporterRunnable)new InitTurtleView(context, as, title, turtleReporter));
        View25DExtension.storeTurtleWindowWithTitle(title, newTurtleView);
    }

    class InitTurtleView
    implements ReporterRunnable<TurtleView> {
        AgentSet agentSet;
        AnonymousReporter turtleReporter;
        Context context;
        String title;

        InitTurtleView(Context context, AgentSet as, String title, AnonymousReporter turtleReporter) {
            this.context = context;
            this.agentSet = as;
            this.context = context;
            this.title = title;
            this.turtleReporter = turtleReporter;
        }

        public TurtleView run() throws LogoException {
            TurtleView manualTurtleView = new TurtleView(this.title, this.agentSet, this.turtleReporter);
            manualTurtleView.postConstructor();
            World w = App.app().workspace().world();
            int worldWidth = w.worldWidth();
            int worldHeight = w.worldHeight();
            int minX = w.minPxcor();
            int minY = w.minPycor();
            int maxX = w.maxPxcor();
            int maxY = w.maxPycor();
            manualTurtleView.setupForRendering(worldWidth, worldHeight, minX, maxX, minY, maxY);
            manualTurtleView.manuallyRefreshReporterView(this.context);
            manualTurtleView.setVisible(true);
            return manualTurtleView;
        }
    }
}

