/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.machinetags;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.machinetags.Namespace;
import com.flickr4java.flickr.machinetags.NamespacesList;
import com.flickr4java.flickr.machinetags.Pair;
import com.flickr4java.flickr.machinetags.Predicate;
import com.flickr4java.flickr.machinetags.Value;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MachinetagsInterface {
    private static final String METHOD_GET_NAMESPACES = "flickr.machinetags.getNamespaces";
    private static final String METHOD_GET_PAIRS = "flickr.machinetags.getPairs";
    private static final String METHOD_GET_PREDICATES = "flickr.machinetags.getPredicates";
    private static final String METHOD_GET_VALUES = "flickr.machinetags.getValues";
    private static final String METHOD_GET_RECENTVALUES = "flickr.machinetags.getRecentValues";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public MachinetagsInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public NamespacesList<Namespace> getNamespaces(String predicate, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        NamespacesList<Namespace> nsList = new NamespacesList<Namespace>();
        parameters.put("method", METHOD_GET_NAMESPACES);
        if (predicate != null) {
            parameters.put("predicate", predicate);
        }
        if (perPage > 0) {
            parameters.put("per_page", "" + perPage);
        }
        if (page > 0) {
            parameters.put("page", "" + page);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element nsElement = response.getPayload();
        NodeList nsNodes = nsElement.getElementsByTagName("namespace");
        nsList.setPage("1");
        nsList.setPages("1");
        nsList.setPerPage("" + nsNodes.getLength());
        nsList.setTotal("" + nsNodes.getLength());
        for (int i = 0; i < nsNodes.getLength(); ++i) {
            Element element = (Element)nsNodes.item(i);
            nsList.add(this.parseNamespace(element));
        }
        return nsList;
    }

    public NamespacesList<Pair> getPairs(String namespace, String predicate, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        NamespacesList<Pair> nsList = new NamespacesList<Pair>();
        parameters.put("method", METHOD_GET_PAIRS);
        if (namespace != null) {
            parameters.put("namespace", namespace);
        }
        if (predicate != null) {
            parameters.put("predicate", predicate);
        }
        if (perPage > 0) {
            parameters.put("per_page", "" + perPage);
        }
        if (page > 0) {
            parameters.put("page", "" + page);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element nsElement = response.getPayload();
        NodeList nsNodes = nsElement.getElementsByTagName("pair");
        nsList.setPage(nsElement.getAttribute("page"));
        nsList.setPages(nsElement.getAttribute("pages"));
        nsList.setPerPage(nsElement.getAttribute("perPage"));
        nsList.setTotal("" + nsNodes.getLength());
        for (int i = 0; i < nsNodes.getLength(); ++i) {
            Element element = (Element)nsNodes.item(i);
            nsList.add(this.parsePair(element));
        }
        return nsList;
    }

    public NamespacesList<Predicate> getPredicates(String namespace, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        NamespacesList<Predicate> nsList = new NamespacesList<Predicate>();
        parameters.put("method", METHOD_GET_PREDICATES);
        if (namespace != null) {
            parameters.put("namespace", namespace);
        }
        if (perPage > 0) {
            parameters.put("per_page", "" + perPage);
        }
        if (page > 0) {
            parameters.put("page", "" + page);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element nsElement = response.getPayload();
        NodeList nsNodes = nsElement.getElementsByTagName("predicate");
        nsList.setPage(nsElement.getAttribute("page"));
        nsList.setPages(nsElement.getAttribute("pages"));
        nsList.setPerPage(nsElement.getAttribute("perPage"));
        nsList.setTotal("" + nsNodes.getLength());
        for (int i = 0; i < nsNodes.getLength(); ++i) {
            Element element = (Element)nsNodes.item(i);
            nsList.add(this.parsePredicate(element));
        }
        return nsList;
    }

    public NamespacesList<Value> getValues(String namespace, String predicate, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        NamespacesList<Value> valuesList = new NamespacesList<Value>();
        parameters.put("method", METHOD_GET_VALUES);
        if (namespace != null) {
            parameters.put("namespace", namespace);
        }
        if (predicate != null) {
            parameters.put("predicate", predicate);
        }
        if (perPage > 0) {
            parameters.put("per_page", "" + perPage);
        }
        if (page > 0) {
            parameters.put("page", "" + page);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element nsElement = response.getPayload();
        NodeList nsNodes = nsElement.getElementsByTagName("value");
        valuesList.setPage(nsElement.getAttribute("page"));
        valuesList.setPages(nsElement.getAttribute("pages"));
        valuesList.setPerPage(nsElement.getAttribute("perPage"));
        valuesList.setTotal("" + nsNodes.getLength());
        for (int i = 0; i < nsNodes.getLength(); ++i) {
            Element element = (Element)nsNodes.item(i);
            Value value = this.parseValue(element);
            value.setNamespace(namespace);
            value.setPredicate(predicate);
            valuesList.add(value);
        }
        return valuesList;
    }

    public NamespacesList<Value> getRecentValues(String namespace, String predicate, Date addedSince) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        NamespacesList<Value> valuesList = new NamespacesList<Value>();
        parameters.put("method", METHOD_GET_RECENTVALUES);
        if (namespace != null) {
            parameters.put("namespace", namespace);
        }
        if (predicate != null) {
            parameters.put("predicate", predicate);
        }
        if (addedSince != null) {
            parameters.put("added_since", Long.toString(addedSince.getTime() / 1000L));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element nsElement = response.getPayload();
        NodeList nsNodes = nsElement.getElementsByTagName("value");
        valuesList.setPage(nsElement.getAttribute("page"));
        valuesList.setPages(nsElement.getAttribute("pages"));
        valuesList.setPerPage(nsElement.getAttribute("perPage"));
        valuesList.setTotal("" + nsNodes.getLength());
        for (int i = 0; i < nsNodes.getLength(); ++i) {
            Element element = (Element)nsNodes.item(i);
            valuesList.add(this.parseValue(element));
        }
        return valuesList;
    }

    private Value parseValue(Element nsElement) {
        Value value = new Value();
        value.setUsage(nsElement.getAttribute("usage"));
        value.setNamespace(nsElement.getAttribute("namespace"));
        value.setPredicate(nsElement.getAttribute("predicate"));
        value.setFirstAdded(nsElement.getAttribute("first_added"));
        value.setLastAdded(nsElement.getAttribute("last_added"));
        value.setValue(XMLUtilities.getValue(nsElement));
        return value;
    }

    private Predicate parsePredicate(Element nsElement) {
        Predicate predicate = new Predicate();
        predicate.setUsage(nsElement.getAttribute("usage"));
        predicate.setNamespaces(nsElement.getAttribute("namespaces"));
        predicate.setValue(XMLUtilities.getValue(nsElement));
        return predicate;
    }

    private Namespace parseNamespace(Element nsElement) {
        Namespace ns = new Namespace();
        ns.setUsage(nsElement.getAttribute("usage"));
        ns.setPredicates(nsElement.getAttribute("predicates"));
        ns.setValue(XMLUtilities.getValue(nsElement));
        return ns;
    }

    private Pair parsePair(Element nsElement) {
        Pair pair = new Pair();
        pair.setUsage(nsElement.getAttribute("usage"));
        pair.setNamespace(nsElement.getAttribute("namespace"));
        pair.setPredicate(nsElement.getAttribute("predicate"));
        return pair;
    }
}

