"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeRatioByGroups = void 0;
var group_data_series_1 = require("../../chart_types/xy_chart/utils/group_data_series");
var common_1 = require("../common");
function computeRatioByGroups(data, groupAccessors, valueAccessor, ratioKeyName) {
    return (0, group_data_series_1.groupBy)(data, groupAccessors, true)
        .map(function (groupedData) {
        var groupSum = groupedData.reduce(function (sum, datum) {
            var value = valueAccessor(datum);
            return sum + ((0, common_1.isFiniteNumber)(value) ? Math.abs(value) : 0);
        }, 0);
        return groupedData.map(function (datum) {
            var _a;
            var value = valueAccessor(datum);
            return __assign(__assign({}, datum), (_a = {}, _a[ratioKeyName] = (0, common_1.isFiniteNumber)(value) ? (groupSum === 0 ? 0 : Math.abs(value) / groupSum) : value, _a));
        });
    })
        .flat();
}
exports.computeRatioByGroups = computeRatioByGroups;
//# sourceMappingURL=data_processing.js.map