"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogReporter = getLogReporter;
var _fs = require("fs");
var _stream = require("stream");
var _goodSqueeze = require("@hapi/good-squeeze");
var _log_format_json = require("./log_format_json");
var _log_format_string = require("./log_format_string");
var _log_interceptor = require("./log_interceptor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-expect-error missing type def

function getLogReporter({
  events,
  config
}) {
  const squeeze = new _goodSqueeze.Squeeze(events);
  const format = config.json ? new _log_format_json.KbnLoggerJsonFormat(config) : new _log_format_string.KbnLoggerStringFormat(config);
  const logInterceptor = new _log_interceptor.LogInterceptor();
  if (config.dest === 'stdout') {
    (0, _stream.pipeline)(logInterceptor, squeeze, format, onFinished);
    // The `pipeline` function is used to properly close all streams in the
    // pipeline in case one of them ends or fails. Since stdout obviously
    // shouldn't be closed in case of a failure in one of the other streams,
    // we're not including that in the call to `pipeline`, but rely on the old
    // `pipe` function instead.
    format.pipe(process.stdout);
  } else {
    const dest = (0, _fs.createWriteStream)(config.dest, {
      flags: 'a',
      encoding: 'utf8'
    });
    (0, _stream.pipeline)(logInterceptor, squeeze, format, dest, onFinished);
  }
  return logInterceptor;
}
function onFinished(err) {
  if (err) {
    // eslint-disable-next-line no-console
    console.error('An unexpected error occurred in the logging pipeline:', err.stack);
  }
}