"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecoveredActionGroup = void 0;
exports.getBuiltinActionGroups = getBuiltinActionGroups;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecoveredActionGroup = exports.RecoveredActionGroup = Object.freeze({
  id: 'recovered',
  name: _i18n.i18n.translate('xpack.alerting.builtinActionGroups.recovered', {
    defaultMessage: 'Recovered'
  })
});
function getBuiltinActionGroups(customRecoveryGroup) {
  return [customRecoveryGroup !== null && customRecoveryGroup !== void 0 ? customRecoveryGroup : RecoveredActionGroup];
}