"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esdocs = esdocs;
var _services = require("../../../public/services");
var _constants = require("../../../common/lib/constants");
var _i18n = require("../../../i18n");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
} /*
  * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
  * or more contributor license agreements. Licensed under the Elastic License
  * 2.0; you may not use this file except in compliance with the Elastic License
  * 2.0.
  */ // @ts-expect-error untyped local
function esdocs() {
  const {
    help,
    args: argHelp
  } = (0, _i18n.getFunctionHelp)().esdocs;
  return {
    name: 'esdocs',
    type: 'datatable',
    context: {
      types: ['filter']
    },
    help,
    args: {
      query: {
        types: ['string'],
        aliases: ['_', 'q'],
        help: argHelp.query,
        default: '-_index:.kibana'
      },
      count: {
        types: ['number'],
        default: 1000,
        help: argHelp.count
      },
      fields: {
        help: argHelp.fields,
        types: ['string']
      },
      index: {
        types: ['string'],
        default: '_all',
        help: argHelp.index
      },
      // TODO: This arg isn't being used in the function.
      // We need to restore this functionality or remove it as an arg.
      metaFields: {
        help: argHelp.metaFields,
        types: ['string']
      },
      sort: {
        types: ['string'],
        help: argHelp.sort
      }
    },
    fn: async (input, args, handlers) => {
      const {
        count,
        index,
        fields,
        sort
      } = args;
      input.and = input.and.concat([{
        type: 'filter',
        filterType: 'luceneQueryString',
        query: args.query,
        and: []
      }]);

      // Load ad-hoc to avoid adding to the page load bundle size
      const squel = await Promise.resolve().then(() => _interopRequireWildcard(require('safe-squel')));
      let query = squel.select({
        autoQuoteTableNames: true,
        autoQuoteFieldNames: true,
        autoQuoteAliasNames: true,
        nameQuoteCharacter: '"'
      });
      if (index) {
        query.from(index);
      }
      if (fields) {
        const allFields = fields.split(',').map(field => field.trim());
        allFields.forEach(field => query = query.field(field));
      }
      if (sort) {
        const [sortField, sortOrder] = sort.split(',').map(str => str.trim());
        if (sortField) {
          query.order(`"${sortField}"`, sortOrder === 'asc');
        }
      }
      const search = _services.searchService.getService().search;
      const req = {
        count,
        query: query.toString(),
        filter: input.and
      };

      // We're requesting the data using the ESSQL strategy because
      // the SQL routes return type information with the result set
      return search.search(req, {
        strategy: _constants.ESSQL_SEARCH_STRATEGY
      }).toPromise().then(resp => {
        return {
          type: 'datatable',
          meta: {
            type: 'essql'
          },
          ...resp
        };
      });
    }
  };
}