"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCanvasShareableState = exports.initialCanvasShareableState = exports.CanvasShareableStateProvider = exports.CanvasShareableContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reducer = require("./reducer");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The initial state for the Canvas Shareable Runtime.
 */
const initialCanvasShareableState = exports.initialCanvasShareableState = {
  renderers: {},
  workpad: null,
  stage: {
    page: 0,
    height: 400,
    width: 600
  },
  footer: {
    isScrubberVisible: false
  },
  settings: {
    autoplay: {
      isEnabled: false,
      interval: '5s'
    },
    toolbar: {
      isAutohide: false
    }
  },
  refs: {
    stage: /*#__PURE__*/_react.default.createRef()
  }
};
const CanvasShareableContext = exports.CanvasShareableContext = /*#__PURE__*/(0, _react.createContext)([initialCanvasShareableState, () => {}]);
const CanvasShareableStateProvider = ({
  initialState,
  children
}) => /*#__PURE__*/_react.default.createElement(CanvasShareableContext.Provider, {
  value: (0, _react.useReducer)(_reducer.reducer, initialState)
}, children);
exports.CanvasShareableStateProvider = CanvasShareableStateProvider;
const useCanvasShareableState = () => (0, _react.useContext)(CanvasShareableContext);
exports.useCanvasShareableState = useCanvasShareableState;