"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.caseTypeField = exports.GetCaseIdsByAlertIdAggsRt = exports.ExternalServiceResponseRt = exports.CasesResponseRt = exports.CasesPatchRequestRt = exports.CasesFindResponseRt = exports.CasesFindRequestRt = exports.CasesClientPostRequestRt = exports.CasesByAlertIdRt = exports.CasesByAlertIDRequestRt = exports.CaseUserActionExternalServiceRt = exports.CaseType = exports.CaseResponseRt = exports.CaseResolveResponseRt = exports.CasePushRequestParamsRt = exports.CasePostRequestRt = exports.CasePatchRequestRt = exports.CaseFullExternalServiceRt = exports.CaseExternalServiceBasicRt = exports.CaseAttributesRt = exports.AllTagsFindRequestRt = exports.AllReportersFindRequestRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _saved_object = require("../saved_object");
var _user = require("../user");
var _comment = require("./comment");
var _status = require("./status");
var _connectors = require("../connectors");
var _sub_case = require("./sub_case");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BucketsAggs = rt.array(rt.type({
  key: rt.string
}));
const GetCaseIdsByAlertIdAggsRt = exports.GetCaseIdsByAlertIdAggsRt = rt.type({
  references: rt.type({
    doc_count: rt.number,
    caseIds: rt.type({
      buckets: BucketsAggs
    })
  })
});
const CasesByAlertIdRt = exports.CasesByAlertIdRt = rt.array(rt.type({
  id: rt.string,
  title: rt.string
}));
let CaseType = exports.CaseType = /*#__PURE__*/function (CaseType) {
  CaseType["collection"] = "collection";
  CaseType["individual"] = "individual";
  return CaseType;
}({});
/**
 * Exposing the field used to define the case type so that it can be used for filtering in saved object find queries.
 */
const caseTypeField = exports.caseTypeField = 'type';
const CaseTypeRt = rt.union([rt.literal(CaseType.collection), rt.literal(CaseType.individual)]);
const SettingsRt = rt.type({
  syncAlerts: rt.boolean
});
const CaseBasicRt = rt.type({
  /**
   * The description of the case
   */
  description: rt.string,
  /**
   * The current status of the case (open, closed, in-progress)
   */
  status: _status.CaseStatusRt,
  /**
   * The identifying strings for filter a case
   */
  tags: rt.array(rt.string),
  /**
   * The title of a case
   */
  title: rt.string,
  /**
   * The type of a case (individual or collection)
   */
  [caseTypeField]: CaseTypeRt,
  /**
   * The external system that the case can be synced with
   */
  connector: _connectors.CaseConnectorRt,
  /**
   * The alert sync settings
   */
  settings: SettingsRt,
  /**
   * The plugin owner of the case
   */
  owner: rt.string
});

/**
 * This represents the push to service UserAction. It lacks the connector_id because that is stored in a different field
 * within the user action object in the API response.
 */
const CaseUserActionExternalServiceRt = exports.CaseUserActionExternalServiceRt = rt.type({
  connector_name: rt.string,
  external_id: rt.string,
  external_title: rt.string,
  external_url: rt.string,
  pushed_at: rt.string,
  pushed_by: _user.UserRT
});
const CaseExternalServiceBasicRt = exports.CaseExternalServiceBasicRt = rt.intersection([rt.type({
  connector_id: rt.union([rt.string, rt.null])
}), CaseUserActionExternalServiceRt]);
const CaseFullExternalServiceRt = exports.CaseFullExternalServiceRt = rt.union([CaseExternalServiceBasicRt, rt.null]);
const CaseAttributesRt = exports.CaseAttributesRt = rt.intersection([CaseBasicRt, rt.type({
  closed_at: rt.union([rt.string, rt.null]),
  closed_by: rt.union([_user.UserRT, rt.null]),
  created_at: rt.string,
  created_by: _user.UserRT,
  external_service: CaseFullExternalServiceRt,
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_user.UserRT, rt.null])
})]);
const CasePostRequestNoTypeRt = rt.type({
  /**
   * Description of the case
   */
  description: rt.string,
  /**
   * Identifiers for the case.
   */
  tags: rt.array(rt.string),
  /**
   * Title of the case
   */
  title: rt.string,
  /**
   * The external configuration for the case
   */
  connector: _connectors.CaseConnectorRt,
  /**
   * Sync settings for alerts
   */
  settings: SettingsRt,
  /**
   * The owner here must match the string used when a plugin registers a feature with access to the cases plugin. The user
   * creating this case must also be granted access to that plugin's feature.
   */
  owner: rt.string
});

/**
 * This type is used for validating a create case request. It requires that the type field be defined.
 */
const CasesClientPostRequestRt = exports.CasesClientPostRequestRt = rt.type({
  ...CasePostRequestNoTypeRt.props,
  [caseTypeField]: CaseTypeRt
});

/**
 * This type is not used for validation when decoding a request because intersection does not have props defined which
 * required for the excess function. Instead we use this as the type used by the UI. This allows the type field to be
 * optional and the server will handle setting it to a default value before validating that the request
 * has all the necessary fields. CasesClientPostRequestRt is used for validation.
 */
const CasePostRequestRt = exports.CasePostRequestRt = rt.intersection([
/**
 * The case type: an individual case (one without children) or a collection case (one with children)
 */
rt.partial({
  [caseTypeField]: CaseTypeRt
}), CasePostRequestNoTypeRt]);
const CasesFindRequestRt = exports.CasesFindRequestRt = rt.partial({
  /**
   * Type of a case (individual, or collection)
   */
  type: CaseTypeRt,
  /**
   * Tags to filter by
   */
  tags: rt.union([rt.array(rt.string), rt.string]),
  /**
   * The status of the case (open, closed, in-progress)
   */
  status: _status.CaseStatusRt,
  /**
   * The reporters to filter by
   */
  reporters: rt.union([rt.array(rt.string), rt.string]),
  /**
   * Operator to use for the `search` field
   */
  defaultSearchOperator: rt.union([rt.literal('AND'), rt.literal('OR')]),
  /**
   * The fields in the entity to return in the response
   */
  fields: rt.array(rt.string),
  /**
   * The page of objects to return
   */
  page: _saved_object.NumberFromString,
  /**
   * The number of objects to include in each page
   */
  perPage: _saved_object.NumberFromString,
  /**
   * An Elasticsearch simple_query_string
   */
  search: rt.string,
  /**
   * The fields to perform the simple_query_string parsed query against
   */
  searchFields: rt.union([rt.array(rt.string), rt.string]),
  /**
   * The field to use for sorting the found objects.
   *
   * This only supports, `create_at`, `closed_at`, and `status`
   */
  sortField: rt.string,
  /**
   * The order to sort by
   */
  sortOrder: rt.union([rt.literal('desc'), rt.literal('asc')]),
  /**
   * The owner(s) to filter by. The user making the request must have privileges to retrieve cases of that
   * ownership or they will be ignored. If no owner is included, then all ownership types will be included in the response
   * that the user has access to.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
});
const CasesByAlertIDRequestRt = exports.CasesByAlertIDRequestRt = rt.partial({
  /**
   * The type of cases to retrieve given an alert ID. If no owner is provided, all cases
   * that the user has access to will be returned.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
});
const CaseResponseRt = exports.CaseResponseRt = rt.intersection([CaseAttributesRt, rt.type({
  id: rt.string,
  totalComment: rt.number,
  totalAlerts: rt.number,
  version: rt.string
}), rt.partial({
  subCaseIds: rt.array(rt.string),
  subCases: rt.array(_sub_case.SubCaseResponseRt),
  comments: rt.array(_comment.CommentResponseRt)
})]);
const CaseResolveResponseRt = exports.CaseResolveResponseRt = rt.intersection([rt.type({
  case: CaseResponseRt,
  outcome: rt.union([rt.literal('exactMatch'), rt.literal('aliasMatch'), rt.literal('conflict')])
}), rt.partial({
  alias_target_id: rt.string
})]);
const CasesFindResponseRt = exports.CasesFindResponseRt = rt.intersection([rt.type({
  cases: rt.array(CaseResponseRt),
  page: rt.number,
  per_page: rt.number,
  total: rt.number
}), _status.CasesStatusResponseRt]);
const CasePatchRequestRt = exports.CasePatchRequestRt = rt.intersection([rt.partial(CaseBasicRt.props),
/**
 * The saved object ID and version
 */
rt.type({
  id: rt.string,
  version: rt.string
})]);
const CasesPatchRequestRt = exports.CasesPatchRequestRt = rt.type({
  cases: rt.array(CasePatchRequestRt)
});
const CasesResponseRt = exports.CasesResponseRt = rt.array(CaseResponseRt);
const CasePushRequestParamsRt = exports.CasePushRequestParamsRt = rt.type({
  case_id: rt.string,
  connector_id: rt.string
});
const ExternalServiceResponseRt = exports.ExternalServiceResponseRt = rt.intersection([rt.type({
  title: rt.string,
  id: rt.string,
  pushedDate: rt.string,
  url: rt.string
}), rt.partial({
  comments: rt.array(rt.intersection([rt.type({
    commentId: rt.string,
    pushedDate: rt.string
  }), rt.partial({
    externalCommentId: rt.string
  })]))
})]);
const AllTagsFindRequestRt = exports.AllTagsFindRequestRt = rt.partial({
  /**
   * The owner of the cases to retrieve the tags from. If no owner is provided the tags from all cases
   * that the user has access to will be returned.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
});
const AllReportersFindRequestRt = exports.AllReportersFindRequestRt = AllTagsFindRequestRt;

/**
 * This field differs from the CasePostRequest in that the post request's type field can be optional. This type requires
 * that the type field be defined. The CasePostRequest should be used in most places (the UI etc). This type is really
 * only necessary for validation.
 */