"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegistryVarsEntryKeys = exports.RegistryStreamKeys = exports.RegistryPolicyTemplateKeys = exports.RegistryInputKeys = exports.RegistryDataStreamKeys = exports.KibanaSavedObjectType = exports.KibanaAssetType = exports.InstallStatus = exports.ElasticsearchAssetType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Follow pattern from https://github.com/elastic/kibana/pull/52447
// TODO: Update when https://github.com/elastic/kibana/issues/53021 is closed
let InstallStatus = exports.InstallStatus = /*#__PURE__*/function (InstallStatus) {
  InstallStatus["installed"] = "installed";
  InstallStatus["notInstalled"] = "not_installed";
  InstallStatus["installing"] = "installing";
  InstallStatus["uninstalling"] = "uninstalling";
  return InstallStatus;
}({});
/*
  Enum mapping of a saved object asset type to how it would appear in a package file path (snake cased)
*/
let KibanaAssetType = exports.KibanaAssetType = /*#__PURE__*/function (KibanaAssetType) {
  KibanaAssetType["dashboard"] = "dashboard";
  KibanaAssetType["visualization"] = "visualization";
  KibanaAssetType["search"] = "search";
  KibanaAssetType["indexPattern"] = "index_pattern";
  KibanaAssetType["map"] = "map";
  KibanaAssetType["lens"] = "lens";
  KibanaAssetType["securityRule"] = "security_rule";
  KibanaAssetType["mlModule"] = "ml_module";
  KibanaAssetType["tag"] = "tag";
  return KibanaAssetType;
}({});
/*
 Enum of saved object types that are allowed to be installed
*/
let KibanaSavedObjectType = exports.KibanaSavedObjectType = /*#__PURE__*/function (KibanaSavedObjectType) {
  KibanaSavedObjectType["dashboard"] = "dashboard";
  KibanaSavedObjectType["visualization"] = "visualization";
  KibanaSavedObjectType["search"] = "search";
  KibanaSavedObjectType["indexPattern"] = "index-pattern";
  KibanaSavedObjectType["map"] = "map";
  KibanaSavedObjectType["lens"] = "lens";
  KibanaSavedObjectType["mlModule"] = "ml-module";
  KibanaSavedObjectType["securityRule"] = "security-rule";
  KibanaSavedObjectType["tag"] = "tag";
  return KibanaSavedObjectType;
}({});
let ElasticsearchAssetType = exports.ElasticsearchAssetType = /*#__PURE__*/function (ElasticsearchAssetType) {
  ElasticsearchAssetType["componentTemplate"] = "component_template";
  ElasticsearchAssetType["ingestPipeline"] = "ingest_pipeline";
  ElasticsearchAssetType["indexTemplate"] = "index_template";
  ElasticsearchAssetType["ilmPolicy"] = "ilm_policy";
  ElasticsearchAssetType["transform"] = "transform";
  ElasticsearchAssetType["dataStreamIlmPolicy"] = "data_stream_ilm_policy";
  return ElasticsearchAssetType;
}({}); // Registry packages do have extra fields.
// cf. type Package struct at https://github.com/elastic/package-registry/blob/master/util/package.go
// our current types have `download`, & `path` as required but they're are optional (have `omitempty`) according to
// https://github.com/elastic/package-registry/blob/master/util/package.go#L57
// & https://github.com/elastic/package-registry/blob/master/util/package.go#L80-L81
// However, they are always present in every registry response I checked. Chose to keep types unchanged for now
// and confirm with Registry if they are really optional. Can update types and ~4 places in code later if neccessary
let RegistryPolicyTemplateKeys = exports.RegistryPolicyTemplateKeys = /*#__PURE__*/function (RegistryPolicyTemplateKeys) {
  RegistryPolicyTemplateKeys["name"] = "name";
  RegistryPolicyTemplateKeys["title"] = "title";
  RegistryPolicyTemplateKeys["description"] = "description";
  RegistryPolicyTemplateKeys["icons"] = "icons";
  RegistryPolicyTemplateKeys["screenshots"] = "screenshots";
  RegistryPolicyTemplateKeys["categories"] = "categories";
  RegistryPolicyTemplateKeys["data_streams"] = "data_streams";
  RegistryPolicyTemplateKeys["inputs"] = "inputs";
  RegistryPolicyTemplateKeys["readme"] = "readme";
  RegistryPolicyTemplateKeys["multiple"] = "multiple";
  return RegistryPolicyTemplateKeys;
}({});
let RegistryInputKeys = exports.RegistryInputKeys = /*#__PURE__*/function (RegistryInputKeys) {
  RegistryInputKeys["type"] = "type";
  RegistryInputKeys["title"] = "title";
  RegistryInputKeys["description"] = "description";
  RegistryInputKeys["template_path"] = "template_path";
  RegistryInputKeys["condition"] = "condition";
  RegistryInputKeys["input_group"] = "input_group";
  RegistryInputKeys["vars"] = "vars";
  return RegistryInputKeys;
}({});
let RegistryStreamKeys = exports.RegistryStreamKeys = /*#__PURE__*/function (RegistryStreamKeys) {
  RegistryStreamKeys["input"] = "input";
  RegistryStreamKeys["title"] = "title";
  RegistryStreamKeys["description"] = "description";
  RegistryStreamKeys["enabled"] = "enabled";
  RegistryStreamKeys["vars"] = "vars";
  RegistryStreamKeys["template_path"] = "template_path";
  return RegistryStreamKeys;
}({}); // Registry's response types
// from /search
// https://github.com/elastic/package-registry/blob/master/docs/api/search.json
// from getPackageOutput at https://github.com/elastic/package-registry/blob/master/search.go
// from /categories
// https://github.com/elastic/package-registry/blob/master/docs/api/categories.json
let RegistryDataStreamKeys = exports.RegistryDataStreamKeys = /*#__PURE__*/function (RegistryDataStreamKeys) {
  RegistryDataStreamKeys["type"] = "type";
  RegistryDataStreamKeys["ilm_policy"] = "ilm_policy";
  RegistryDataStreamKeys["hidden"] = "hidden";
  RegistryDataStreamKeys["dataset"] = "dataset";
  RegistryDataStreamKeys["title"] = "title";
  RegistryDataStreamKeys["release"] = "release";
  RegistryDataStreamKeys["streams"] = "streams";
  RegistryDataStreamKeys["package"] = "package";
  RegistryDataStreamKeys["path"] = "path";
  RegistryDataStreamKeys["ingest_pipeline"] = "ingest_pipeline";
  RegistryDataStreamKeys["elasticsearch"] = "elasticsearch";
  RegistryDataStreamKeys["dataset_is_prefix"] = "dataset_is_prefix";
  return RegistryDataStreamKeys;
}({});
let RegistryVarsEntryKeys = exports.RegistryVarsEntryKeys = /*#__PURE__*/function (RegistryVarsEntryKeys) {
  RegistryVarsEntryKeys["name"] = "name";
  RegistryVarsEntryKeys["title"] = "title";
  RegistryVarsEntryKeys["description"] = "description";
  RegistryVarsEntryKeys["type"] = "type";
  RegistryVarsEntryKeys["required"] = "required";
  RegistryVarsEntryKeys["show_user"] = "show_user";
  RegistryVarsEntryKeys["multi"] = "multi";
  RegistryVarsEntryKeys["default"] = "default";
  RegistryVarsEntryKeys["os"] = "os";
  return RegistryVarsEntryKeys;
}({}); // EPR types this as `[]map[string]interface{}`
// which means the official/possible type is Record<string, any>
// but we effectively only see this shape
// some properties are optional in Registry responses but required in EPM
// internal until we need them
// Managers public HTTP response types
// This is an index template v2, see https://github.com/elastic/elasticsearch/issues/53101
// until "proper" documentation of the new format is available.
// Fleet does not use nor support the legacy index template v1 format at all