"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntryCategoryRT = exports.logEntryCategoryHistogramRT = exports.logEntryCategoryHistogramBucketRT = exports.logEntryCategoryDatasetRT = exports.logEntryCategoriesJobTypes = exports.logEntryCategoriesJobTypeRT = exports.categoriesSortRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _log_analysis_results = require("./log_analysis_results");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logEntryCategoriesJobTypeRT = exports.logEntryCategoriesJobTypeRT = rt.keyof({
  'log-entry-categories-count': null
});
const logEntryCategoriesJobTypes = exports.logEntryCategoriesJobTypes = ['log-entry-categories-count'];
const logEntryCategoryDatasetRT = exports.logEntryCategoryDatasetRT = rt.type({
  name: rt.string,
  maximumAnomalyScore: rt.number
});
const logEntryCategoryHistogramBucketRT = exports.logEntryCategoryHistogramBucketRT = rt.type({
  startTime: rt.number,
  bucketDuration: rt.number,
  logEntryCount: rt.number
});
const logEntryCategoryHistogramRT = exports.logEntryCategoryHistogramRT = rt.type({
  histogramId: rt.string,
  buckets: rt.array(logEntryCategoryHistogramBucketRT)
});
const logEntryCategoryRT = exports.logEntryCategoryRT = rt.type({
  categoryId: rt.number,
  datasets: rt.array(logEntryCategoryDatasetRT),
  histograms: rt.array(logEntryCategoryHistogramRT),
  logEntryCount: rt.number,
  maximumAnomalyScore: rt.number,
  regularExpression: rt.string
});
const sortOptionsRT = rt.keyof({
  maximumAnomalyScore: null,
  logEntryCount: null
});
const categoriesSortRT = exports.categoriesSortRT = (0, _log_analysis_results.sortRT)(sortOptionsRT);