"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPERATOR = exports.FILTER_TYPE = exports.CONDITIONS_NOT_SUPPORTED_FUNCTIONS = exports.APPLIES_TO = exports.ACTION = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Contains values for ML job detector rules.
 */
let ACTION = exports.ACTION = /*#__PURE__*/function (ACTION) {
  ACTION["SKIP_MODEL_UPDATE"] = "skip_model_update";
  ACTION["SKIP_RESULT"] = "skip_result";
  return ACTION;
}({});
let FILTER_TYPE = exports.FILTER_TYPE = /*#__PURE__*/function (FILTER_TYPE) {
  FILTER_TYPE["EXCLUDE"] = "exclude";
  FILTER_TYPE["INCLUDE"] = "include";
  return FILTER_TYPE;
}({});
let APPLIES_TO = exports.APPLIES_TO = /*#__PURE__*/function (APPLIES_TO) {
  APPLIES_TO["ACTUAL"] = "actual";
  APPLIES_TO["DIFF_FROM_TYPICAL"] = "diff_from_typical";
  APPLIES_TO["TYPICAL"] = "typical";
  return APPLIES_TO;
}({});
let OPERATOR = exports.OPERATOR = /*#__PURE__*/function (OPERATOR) {
  OPERATOR["LESS_THAN"] = "lt";
  OPERATOR["LESS_THAN_OR_EQUAL"] = "lte";
  OPERATOR["GREATER_THAN"] = "gt";
  OPERATOR["GREATER_THAN_OR_EQUAL"] = "gte";
  return OPERATOR;
}({}); // List of detector functions which don't support rules with numeric conditions.
const CONDITIONS_NOT_SUPPORTED_FUNCTIONS = exports.CONDITIONS_NOT_SUPPORTED_FUNCTIONS = ['freq_rare', 'lat_long', 'metric', 'rare'];