"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForVisualizations = void 0;
var _i18n = require("@kbn/i18n");
var _ = require("../");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCompletedItemsCount = ({
  count,
  renderCompleteSelector
}) => {
  const {
    length
  } = document.querySelectorAll(renderCompleteSelector);

  // eslint-disable-next-line no-console
  console.debug(`waitng for ${count} elements, got ${length}.`);
  return length >= count;
};

/*
 * 1. Wait for the visualization metadata to be found in the DOM
 * 2. Read the metadata for the number of visualization items
 * 3. Wait for the render complete event to be fired once for each item
 */
const waitForVisualizations = async (timeout, browser, toEqual, layout, logger) => {
  const endTrace = (0, _.startTrace)('wait_for_visualizations', 'wait');
  const {
    renderComplete: renderCompleteSelector
  } = layout.selectors;
  logger.debug(`Waiting for ${toEqual} rendered elements to be in the DOM`);
  try {
    await browser.waitFor({
      fn: getCompletedItemsCount,
      args: [{
        renderCompleteSelector,
        count: toEqual
      }],
      timeout
    });
    logger.debug(`found ${toEqual} rendered elements in the DOM`);
  } catch (err) {
    logger.error(err);
    throw new Error(_i18n.i18n.translate('xpack.reporting.screencapture.couldntFinishRendering', {
      defaultMessage: `An error occurred when trying to wait for {count} visualizations to finish rendering. {error}`,
      values: {
        count: toEqual,
        error: err
      }
    }));
  }
  endTrace();
};
exports.waitForVisualizations = waitForVisualizations;