"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchProfilerServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _common = require("../common");
var profileRoute = _interopRequireWildcard(require("./routes/profile"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchProfilerServerPlugin {
  constructor({
    logger
  }) {
    (0, _defineProperty2.default)(this, "licenseStatus", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    this.log = logger.get();
    this.licenseStatus = {
      valid: false
    };
  }
  setup({
    http
  }, {
    licensing
  }) {
    const router = http.createRouter();
    profileRoute.register({
      router,
      getLicenseStatus: () => this.licenseStatus,
      log: this.log
    });
    licensing.license$.subscribe(license => {
      const {
        state,
        message
      } = license.check(_common.PLUGIN.id, _common.PLUGIN.minimumLicenseType);
      const hasRequiredLicense = state === 'valid';
      if (hasRequiredLicense) {
        this.licenseStatus = {
          valid: true
        };
      } else {
        this.licenseStatus = {
          valid: false,
          message: message ||
          // Ensure that there is a message when license check fails
          _i18n.i18n.translate('xpack.searchProfiler.licenseCheckErrorMessage', {
            defaultMessage: 'License check failed'
          })
        };
        if (message) {
          this.log.info(message);
        }
      }
    });
  }
  start() {}
  stop() {}
}
exports.SearchProfilerServerPlugin = SearchProfilerServerPlugin;