"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StateType = exports.SortOrder = exports.MonitorSummaryType = exports.MonitorSummariesResultType = exports.HistogramType = exports.HistogramPointType = exports.FetchMonitorStatesQueryArgsType = exports.CursorDirection = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ping = require("../ping/ping");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StateType = exports.StateType = t.intersection([t.type({
  timestamp: t.string,
  url: t.partial({
    domain: t.string,
    full: t.string,
    path: t.string,
    port: t.number,
    scheme: t.string
  }),
  summaryPings: t.array(_ping.PingType),
  summary: t.partial({
    status: t.string,
    up: t.number,
    down: t.number
  }),
  monitor: t.intersection([t.partial({
    name: t.string
  }), t.type({
    type: t.string
  })])
}), t.partial({
  tls: t.partial({
    not_after: t.union([t.string, t.null]),
    not_before: t.union([t.string, t.null])
  }),
  observer: t.type({
    geo: t.type({
      name: t.array(t.string)
    })
  }),
  service: t.partial({
    name: t.string
  })
})]);
const HistogramPointType = exports.HistogramPointType = t.type({
  timestamp: t.number,
  up: t.union([t.number, t.undefined]),
  down: t.union([t.number, t.undefined])
});
const HistogramType = exports.HistogramType = t.type({
  points: t.array(HistogramPointType)
});
const MonitorSummaryType = exports.MonitorSummaryType = t.intersection([t.type({
  monitor_id: t.string,
  state: StateType
}), t.partial({
  histogram: HistogramType,
  minInterval: t.number
})]);
const MonitorSummariesResultType = exports.MonitorSummariesResultType = t.intersection([t.partial({
  totalSummaryCount: t.number
}), t.type({
  summaries: t.array(MonitorSummaryType),
  prevPagePagination: t.union([t.string, t.null]),
  nextPagePagination: t.union([t.string, t.null])
})]);
const FetchMonitorStatesQueryArgsType = exports.FetchMonitorStatesQueryArgsType = t.intersection([t.partial({
  pagination: t.string,
  filters: t.string,
  statusFilter: t.string,
  query: t.string
}), t.type({
  dateRangeStart: t.string,
  dateRangeEnd: t.string,
  pageSize: t.number
})]);
let CursorDirection = exports.CursorDirection = /*#__PURE__*/function (CursorDirection) {
  CursorDirection["AFTER"] = "AFTER";
  CursorDirection["BEFORE"] = "BEFORE";
  return CursorDirection;
}({});
let SortOrder = exports.SortOrder = /*#__PURE__*/function (SortOrder) {
  SortOrder["ASC"] = "ASC";
  SortOrder["DESC"] = "DESC";
  return SortOrder;
}({});