/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.inspections.JSUnresolvedLibraryURLInspection;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionDialog;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionView;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DownloadLibraryQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(JSUnresolvedLibraryURLInspection.class);
    private String myTestRoot;

    @TestOnly
    public void setTestRoot(String testRoot) {
        this.myTestRoot = testRoot;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.library.download.fix", new Object[0]);
        if (string == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement attrValue;
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(2);
        }
        if ((attrValue = descriptor.getPsiElement()) != null) {
            String location = StringUtil.unquoteString((String)attrValue.getText());
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            PsiFile psiFile = attrValue.getContainingFile();
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attrValue, XmlTag.class);
            String defaultExtension = ".js";
            if (tag != null && "link".equals(tag.getLocalName()) && "stylesheet".equals(tag.getAttributeValue("rel"))) {
                defaultExtension = ".css";
            }
            this.download(editor, project, psiFile != null ? psiFile.getVirtualFile() : null, location, defaultExtension);
        }
    }

    public void download(final @Nullable Editor editor, final @NotNull Project project, final @Nullable VirtualFile referencingFile, final @NotNull String libraryFileUrl, final @NotNull String defaultExtension) {
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(3);
        }
        if (libraryFileUrl == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(4);
        }
        if (defaultExtension == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            JSDownloadManager downloadManager = new JSDownloadManager(this.myTestRoot);
            String targetPath = downloadManager.downloadLibrary(libraryFileUrl, defaultExtension);
            if (StringUtil.isNotEmpty((String)targetPath)) {
                DownloadLibraryQuickFix.addLibrary(project, referencingFile, libraryFileUrl, targetPath);
            }
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(project, JavaScriptBundle.message("js.library.downloading.library", new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSDownloadManager downloadManager = new JSDownloadManager(DownloadLibraryQuickFix.this.myTestRoot);
                downloadManager.setProgressIndicator(indicator);
                JSDownloadManager.JSDownloadException exception = null;
                String downloadedLibraryFilePath = null;
                boolean tryAgain = true;
                while (tryAgain) {
                    downloadedLibraryFilePath = downloadManager.downloadLibrary(libraryFileUrl, defaultExtension);
                    exception = downloadManager.getLastException();
                    if (exception == null) break;
                    String reason = exception.getReason();
                    String dialogText = reason.contains(libraryFileUrl) ? reason : JavaScriptBundle.message("dialog.message.failed.to.download.0.1", libraryFileUrl, reason);
                    tryAgain = IOExceptionDialog.showErrorDialog((String)JavaScriptBundle.message("dialog.title.download.error", new Object[0]), (String)dialogText);
                }
                if (exception != null) {
                    LOG.info(exception);
                } else {
                    DownloadLibraryQuickFix.addLibrary(project, referencingFile, libraryFileUrl, Objects.requireNonNull(downloadedLibraryFilePath));
                    if (editor != null) {
                        ApplicationManager.getApplication().invokeLater(() -> DownloadLibraryQuickFix.showStatus(project, editor, JavaScriptBundle.message("js.library.successfully.downloaded", downloadManager.getActualSource()), MessageType.INFO, true));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix$1", "run"));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
    }

    public static void showStatus(@NotNull Project project, @NotNull Editor editor, @NotNull @NlsContexts.PopupContent String message, @NotNull MessageType messageType, boolean fadeout) {
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(7);
        }
        if (message == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(8);
        }
        if (messageType == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(9);
        }
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserUtil.browse((URL)e.getURL());
                }
            }
        }).setFadeoutTime(fadeout ? 3000L : -1L).createBalloon();
        RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)JSDisposable.getInstance(project), (Disposable)balloon);
    }

    private static void addLibrary(@NotNull Project project, @Nullable VirtualFile referencingFile, @NotNull String libraryFileUrl, @NotNull String downloadedLibraryFilePath) {
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(10);
        }
        if (libraryFileUrl == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(11);
        }
        if (downloadedLibraryFilePath == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().invokeLater(() -> DownloadLibraryQuickFix.doAddLibrary(project, referencingFile, libraryFileUrl, downloadedLibraryFilePath), project.getDisposed());
    }

    private static void doAddLibrary(@NotNull Project project, @Nullable VirtualFile referencingFile, @NotNull String libraryFileUrl, @NotNull String downloadedLibraryFilePath) {
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(13);
        }
        if (libraryFileUrl == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(14);
        }
        if (downloadedLibraryFilePath == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(15);
        }
        File libFile = new File(downloadedLibraryFilePath);
        assert (libFile.exists()) : "Library file does not exist at " + downloadedLibraryFilePath;
        VirtualFile librarySourceFile = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libFile));
        if (librarySourceFile == null || !librarySourceFile.exists()) {
            LOG.error("Library file not found: " + downloadedLibraryFilePath + ", file = " + libraryFileUrl);
            return;
        }
        String libraryName = JSLibraryUtil.getLibName(libraryFileUrl);
        List<VirtualFile> roots = DownloadLibraryQuickFix.getRootsToAssociateWith(project, referencingFile, libraryName);
        if (roots == null) {
            return;
        }
        WriteAction.run(() -> {
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
            Library library = libTable.getLibraryByName(libraryName);
            if (library == null) {
                String[] stringArray;
                String key;
                String libUrl = VfsUtilCore.pathToUrl((String)libFile.getAbsolutePath());
                String docUrl = null;
                ScriptingFrameworkDescriptor framework = JSProjectUtil.detectFramework(libUrl);
                if (framework != null && (key = JSExternalLibraryDocBundle.getBaseKey(framework.getFrameworkName(), framework.getFrameworkVersion())) != null) {
                    docUrl = JSExternalLibraryDocBundle.getBaseUrl(key);
                }
                VirtualFile[] virtualFileArray = new VirtualFile[]{librarySourceFile};
                if (docUrl == null) {
                    stringArray = ArrayUtilRt.EMPTY_STRING_ARRAY;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = docUrl;
                }
                ScriptingLibraryModel model = libraryManager.createLibrary(libraryName, virtualFileArray, VirtualFile.EMPTY_ARRAY, stringArray, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
                model.setFrameworkDescriptor(framework);
                ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
                for (VirtualFile root : roots) {
                    mappings.associate(root, libraryName);
                }
                libraryManager.commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
            } else {
                ScriptingLibraryTable libraryTable = libraryManager.getScriptingLibraryTable();
                ScriptingLibraryModel model = libraryTable.getModel(library);
                if (model != null && model.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
                    Set sources = model.getSourceFiles();
                    HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(sources);
                    result2.add(librarySourceFile);
                    model.setSourceFiles(VfsUtilCore.toVirtualFileArray(result2));
                    libraryManager.commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
                }
            }
        });
    }

    @Nullable
    private static List<VirtualFile> getRootsToAssociateWith(@NotNull Project project, @Nullable VirtualFile referencingFile, @NotNull String libraryName) {
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(16);
        }
        if (libraryName == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(17);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Collections.singletonList(null);
        }
        ModuleScopeSelectionView view = new ModuleScopeSelectionView(project, referencingFile, true, false);
        if (view.isAssociateWithProjectView()) {
            return view.getLibraryScope();
        }
        ModuleScopeSelectionDialog dialog = new ModuleScopeSelectionDialog(project, libraryName, view);
        if (dialog.showAndGet()) {
            return dialog.getView().getLibraryScope();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFileUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExtension";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadedLibraryFilePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showStatus";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doAddLibrary";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToAssociateWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

