/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageInstaller
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(PackageInstaller.class);
    @NotNull
    private final Project myNotNullProject;
    @NotNull
    private final NodeJsInterpreter myInterpreter;
    @NotNull
    private final NodePackageRef myNpmPackageRef;
    @NotNull
    private final String myPackageName;
    @Nullable
    private final String myVersion;
    @NotNull
    private final Path myWorkingDir;
    @NotNull
    private final PackageManagementService.Listener myListener;
    @Nullable
    private final String myExtraOptions;
    @Nullable
    private @NlsContexts.DetailedDescription String myError;

    public PackageInstaller(@NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @NotNull String packageName, @Nullable String version2, @NotNull File workingDir, @NotNull PackageManagementService.Listener listener2, @Nullable String extraOptions) {
        if (project == null) {
            PackageInstaller.$$$reportNull$$$0(0);
        }
        if (interpreter2 == null) {
            PackageInstaller.$$$reportNull$$$0(1);
        }
        if (packageName == null) {
            PackageInstaller.$$$reportNull$$$0(2);
        }
        if (workingDir == null) {
            PackageInstaller.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            PackageInstaller.$$$reportNull$$$0(4);
        }
        this(project, interpreter2, NpmUtil.createProjectPackageManagerPackageRef(), packageName, version2, workingDir.toPath(), listener2, extraOptions);
    }

    public PackageInstaller(@NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackageRef npmPackageRef, @NotNull String packageName, @Nullable String version2, @NotNull Path workingDir, @NotNull PackageManagementService.Listener listener2, @Nullable String extraOptions) {
        if (project == null) {
            PackageInstaller.$$$reportNull$$$0(5);
        }
        if (interpreter2 == null) {
            PackageInstaller.$$$reportNull$$$0(6);
        }
        if (npmPackageRef == null) {
            PackageInstaller.$$$reportNull$$$0(7);
        }
        if (packageName == null) {
            PackageInstaller.$$$reportNull$$$0(8);
        }
        if (workingDir == null) {
            PackageInstaller.$$$reportNull$$$0(9);
        }
        if (listener2 == null) {
            PackageInstaller.$$$reportNull$$$0(10);
        }
        super(project, JavaScriptBundle.message("progress.title.install.npm.module", packageName), false);
        this.myNotNullProject = project;
        this.myInterpreter = interpreter2;
        this.myNpmPackageRef = npmPackageRef;
        this.myPackageName = packageName;
        this.myVersion = version2;
        this.myWorkingDir = workingDir;
        this.myListener = listener2;
        this.myExtraOptions = extraOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final @NotNull ProgressIndicator indicator) {
        NodeTargetRun targetRun;
        if (indicator == null) {
            PackageInstaller.$$$reportNull$$$0(11);
        }
        Object packageAndVersion = this.myPackageName;
        if (this.myVersion != null) {
            packageAndVersion = (String)packageAndVersion + "@" + this.myVersion;
        }
        SmartList args = new SmartList(packageAndVersion);
        if (this.myExtraOptions != null) {
            Collections.addAll(args, this.myExtraOptions.split(" +"));
        }
        if ((targetRun = (NodeTargetRun)PackageInstaller.computeAndReportIfFailed(this.myListener, this.myPackageName, () -> this.lambda$run$0((List)args))) == null) {
            return;
        }
        indicator.pushState();
        try {
            this.myListener.operationStarted(this.myPackageName);
            ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
            KillableProcessHandler processHandler = processWithCmdLine.getProcessHandler();
            CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processHandler);
            NodePackageRef npmPkgRef = this.myProject != null ? NpmManager.getInstance(this.myProject).getPackageRef() : NodePackageRef.create("npm");
            indicator.setText(JavaScriptBundle.message("progress.subtitle.install", packageAndVersion, NpmManager.getNpmPackagePresentableName(npmPkgRef)));
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    String line;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (ProcessOutputType.isStdout((Key)outputType) && (line = (String)ArrayUtil.getLastElement((Object[])StringUtil.splitByLines((String)event.getText(), (boolean)true))) != null) {
                        indicator.setText2(line.trim());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/modules/PackageInstaller$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ProcessOutput output = runner.runProcess(indicator);
            if (output.getExitCode() != 0) {
                this.myError = NodeCommandLineUtil.formatErrorMessage(processWithCmdLine.getCommandLinePresentation(), output);
            }
        }
        catch (ExecutionException e) {
            this.myError = e.getMessage();
        }
        finally {
            indicator.popState();
            this.myListener.operationFinished(this.myPackageName, PackageManagementService.ErrorDescription.fromMessage((String)this.myError));
            LocalFileSystem.getInstance().refresh(true);
        }
    }

    @Nullable
    public static <T, E extends Exception> T computeAndReportIfFailed(@NotNull PackageManagementService.Listener listener2, @NotNull String packageName, @NotNull ThrowableComputable<T, E> computable) {
        if (listener2 == null) {
            PackageInstaller.$$$reportNull$$$0(12);
        }
        if (packageName == null) {
            PackageInstaller.$$$reportNull$$$0(13);
        }
        if (computable == null) {
            PackageInstaller.$$$reportNull$$$0(14);
        }
        try {
            return (T)computable.compute();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            listener2.operationFinished(packageName, PackageManagementService.ErrorDescription.fromMessage((String)e.getMessage()));
            return null;
        }
    }

    private /* synthetic */ NodeTargetRun lambda$run$0(List args) throws ExecutionException {
        NodeTargetRun result2 = new NodeTargetRun(this.myInterpreter, this.myNotNullProject, null, NodeTargetRunOptions.of(false));
        NpmRunProfileState.configureCommandLine(result2, "", this.myNpmPackageRef, this.myWorkingDir.resolve("package.json").toString(), NpmCommand.ADD, List.of(), ParametersListUtil.join((List)args), EnvironmentVariablesData.DEFAULT, null);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackageRef";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/PackageInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAndReportIfFailed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Component
    implements NpmPackageInstallerLight {
        @Override
        public void installPackage(@NotNull Project project, @NotNull NodeJsInterpreter localInterpreter, @NotNull String packageName, @Nullable String version2, @NotNull File workingDir, @NotNull PackageManagementService.Listener listener2, @Nullable String extraOptions) {
            if (project == null) {
                Component.$$$reportNull$$$0(0);
            }
            if (localInterpreter == null) {
                Component.$$$reportNull$$$0(1);
            }
            if (packageName == null) {
                Component.$$$reportNull$$$0(2);
            }
            if (workingDir == null) {
                Component.$$$reportNull$$$0(3);
            }
            if (listener2 == null) {
                Component.$$$reportNull$$$0(4);
            }
            ProgressManager.getInstance().run((Task)new PackageInstaller(project, localInterpreter, packageName, version2, workingDir, listener2, extraOptions));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localInterpreter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/modules/PackageInstaller$Component";
            objectArray[2] = "installPackage";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

