/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSClassMemberReferencesVisitor;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSPullUpConflictsUtil {
    public static MultiMap<PsiElement, String> checkConflicts(JSMemberInfo @NotNull [] infos, @NotNull JSClass subclass, @NotNull JSClass superClass, @NotNull JSInterfaceContainmentVerifier interfaceContainmentVerifier, @NotNull JSVisibilityUtil.Options options) {
        if (subclass == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(0);
        }
        if (superClass == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(1);
        }
        if (interfaceContainmentVerifier == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(2);
        }
        if (options == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(3);
        }
        if (infos == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(4);
        }
        MultiMap conflicts = new MultiMap();
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(subclass);
        JSRefactoringConflictsUtil.checkIncomingReferencesAccessibility(JSRefactoringUtil.getUsages(JSMemberInfo.getStatics(infos), superClass), superClass, "escalate", (MultiMap<PsiElement, String>)conflicts, options);
        for (JSMemberInfo info2 : infos) {
            JSRefactoringConflictsUtil.checkMemberExist((JSAttributeListOwner)info2.getMember(), superClass, (MultiMap<PsiElement, String>)conflicts);
        }
        if (!superClass.isInterface() && !JSRefactoringUtil.isAbstract(superClass, superClass) && ContainerUtil.or((Object[])infos, info -> info.isToAbstract())) {
            String text = JavaScriptBundle.message("js.pull.up.will.be.made.abstract", RefactoringUIUtil.getDescription((PsiElement)superClass, (boolean)false));
            conflicts.putValue((Object)superClass, (Object)text);
        }
        if (dialect != null && dialect.isECMA4 && superClass.isInterface()) {
            JSPullUpConflictsUtil.checkNoFieldsInInterface(infos, (MultiMap<PsiElement, String>)conflicts);
        }
        if (dialect != null && dialect.isTypeScript && !superClass.isInterface()) {
            JSPullUpConflictsUtil.checkNoOverloadsWithoutImplementation(infos, (MultiMap<PsiElement, String>)conflicts);
        }
        if (dialect != null && (dialect.isTypeScript || dialect.isECMA6) && superClass.getContainingFile() != subclass.getContainingFile()) {
            JSPullUpConflictsUtil.checkUsagesOfNonExported(infos, superClass, (MultiMap<PsiElement, String>)conflicts);
        }
        HashSet<JSAttributeListOwner> membersToMove = new HashSet<JSAttributeListOwner>();
        HashSet<JSFunction> methodsToAbstract = new HashSet<JSFunction>();
        for (JSMemberInfo info3 : infos) {
            JSAttributeListOwner member = (JSAttributeListOwner)info3.getMember();
            if (member instanceof JSFunction && superClass.isInterface()) {
                methodsToAbstract.add((JSFunction)member);
                continue;
            }
            membersToMove.add(member);
        }
        for (JSAttributeListOwner member : membersToMove) {
            if (member instanceof JSClass) {
                if (JSVisibilityUtil.isAccessible((PsiElement)member, (JSAttributeList)null, null, (PsiElement)superClass, JSVisibilityUtil.DEFAULT_OPTIONS)) continue;
                String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{JSRefactoringUtil.getKindAndLongName((PsiElement)member), JSFormatUtil.formatVisibility(member.getAttributeList().getAccessType()), JSRefactoringUtil.getKindAndLongName(superClass)});
                message = StringUtil.capitalize((String)message);
                conflicts.putValue((Object)subclass, (Object)message);
                continue;
            }
            NonAccessibleUsagesOfSubClassMembers visitor = new NonAccessibleUsagesOfSubClassMembers((PsiElement)member, membersToMove, methodsToAbstract, subclass, superClass, (MultiMap<PsiElement, String>)conflicts, interfaceContainmentVerifier);
            member.accept(visitor);
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)member, membersToMove, superClass, true, (MultiMap<PsiElement, String>)conflicts, (Condition<? super PsiElement>)((Condition)element -> !JSInheritanceUtil.isMemberOfSubclass(superClass, (JSElement)element, true)), options);
        }
        for (JSFunction member : methodsToAbstract) {
            JSRefactoringConflictsUtil.checkOutgoingReferencesInSignatureAccessibility(member, superClass, true, (MultiMap<PsiElement, String>)conflicts, options);
        }
        ArrayList<JSParameterList> checkModuleConflictsFor = new ArrayList<JSParameterList>(membersToMove);
        for (JSFunction method : methodsToAbstract) {
            checkModuleConflictsFor.add(method.getParameterList());
            PsiElement element2 = method.getReturnTypeElement();
            if (element2 == null) continue;
            checkModuleConflictsFor.add((JSParameterList)element2);
        }
        if (dialect != null && dialect.isECMA4) {
            JSRefactoringConflictsUtil.analyzeModuleConflicts(subclass.getProject(), checkModuleConflictsFor, UsageInfo.EMPTY_ARRAY, superClass, (MultiMap<PsiElement, String>)conflicts);
        }
        return conflicts;
    }

    private static void checkNoOverloadsWithoutImplementation(JSMemberInfo @NotNull [] infos, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (conflicts == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(5);
        }
        if (infos == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(6);
        }
        for (JSMemberInfo info : infos) {
            TypeScriptFunction implementation;
            TypeScriptFunction typeScriptFunction;
            TypeScriptFunction typeScriptFunction2 = typeScriptFunction = info.getMember() instanceof TypeScriptFunction ? (TypeScriptFunction)info.getMember() : null;
            if (typeScriptFunction == null || !typeScriptFunction.isOverloadDeclaration() || ContainerUtil.find((Object[])infos, arg_0 -> JSPullUpConflictsUtil.lambda$checkNoOverloadsWithoutImplementation$3(implementation = (TypeScriptFunction)ContainerUtil.find(typeScriptFunction.getOverloadDeclarations(), t -> t.isOverloadImplementation()), arg_0)) != null) continue;
            String description = RefactoringUIUtil.getDescription((PsiElement)typeScriptFunction, (boolean)false);
            String message = JavaScriptBundle.message("es6.extract.super.overload.declaration.without.implementation.conflict", description);
            conflicts.putValue((Object)typeScriptFunction, (Object)message);
        }
    }

    private static void checkUsagesOfNonExported(JSMemberInfo @NotNull [] infos, @NotNull JSClass superClass, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (superClass == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(7);
        }
        if (conflicts == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(8);
        }
        if (infos == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(9);
        }
        for (JSMemberInfo info : infos) {
            JSPsiElementBase element = (JSPsiElementBase)ObjectUtils.tryCast((Object)info.getMember(), JSPsiElementBase.class);
            if (element == null) continue;
            ES6ReferenceExpressionsInfo usageInfo = JSPullUpConflictsUtil.buildInfo(superClass, element, info.isToAbstract());
            ES6ReferenceExpressionsInfo.addValidations(usageInfo, element, (Condition<? super PsiElement>)Conditions.alwaysFalse(), conflicts);
        }
    }

    @NotNull
    private static ES6ReferenceExpressionsInfo buildInfo(@NotNull JSClass destinationClass, @NotNull JSPsiElementBase element, boolean isAbstract) {
        PsiElement sourceModule;
        if (destinationClass == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(10);
        }
        if (element == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(11);
        }
        if ((sourceModule = ES6PsiUtil.findExternalModule((PsiElement)element)) == null || ES6PsiUtil.findExternalModule(destinationClass) == null) {
            ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.EMPTY;
            if (eS6ReferenceExpressionsInfo == null) {
                JSPullUpConflictsUtil.$$$reportNull$$$0(12);
            }
            return eS6ReferenceExpressionsInfo;
        }
        JSPsiElementBase toCheck = null;
        if (destinationClass.isInterface()) {
            toCheck = JSRefactoringUtil.tryBuildInterfaceSignature(element);
        } else if (isAbstract && element instanceof JSFunction) {
            toCheck = JSRefactoringUtil.buildAbstractMethodSignature((JSFunction)element, DialectDetector.isTypeScript(destinationClass));
        }
        if (toCheck != null) {
            toCheck.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)element.getParent());
        } else {
            toCheck = element;
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo((PsiElement)toCheck, sourceModule);
        if (eS6ReferenceExpressionsInfo == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(13);
        }
        return eS6ReferenceExpressionsInfo;
    }

    private static void checkNoFieldsInInterface(JSMemberInfo[] infos, MultiMap<PsiElement, String> conflicts) {
        for (JSMemberInfo info : infos) {
            PsiElement member = info.getMember();
            if (!(member instanceof JSVariable)) continue;
            String message = JavaScriptBundle.message("0.is.not.allowed.in.interface", RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false));
            conflicts.putValue((Object)member, (Object)StringUtil.capitalize((String)message));
        }
    }

    private static /* synthetic */ boolean lambda$checkNoOverloadsWithoutImplementation$3(TypeScriptFunction implementation, JSMemberInfo t) {
        return t.getMember() == implementation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subclass";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceContainmentVerifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpConflictsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpConflictsUtil";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkConflicts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkNoOverloadsWithoutImplementation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkUsagesOfNonExported";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildInfo";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13 -> new IllegalStateException(string);
        };
    }

    private static class NonAccessibleUsagesOfSubClassMembers
    extends JSClassMemberReferencesVisitor {
        private final PsiElement myScope;
        private final Set<JSAttributeListOwner> myMovedMembers;
        private final Set<JSFunction> myAbstractMethods;
        private final JSClass mySuperClass;
        private final MultiMap<PsiElement, String> myConflictsList;
        private final JSInterfaceContainmentVerifier myInterfaceContainmentVerifier;

        NonAccessibleUsagesOfSubClassMembers(PsiElement scope2, Set<JSAttributeListOwner> movedMembers, Set<JSFunction> abstractMethods, JSClass subclass, JSClass superClass, MultiMap<PsiElement, String> conflictsList, JSInterfaceContainmentVerifier interfaceContainmentVerifier) {
            super(subclass);
            this.myScope = scope2;
            this.myMovedMembers = movedMembers;
            this.myAbstractMethods = abstractMethods;
            this.mySuperClass = superClass;
            this.myConflictsList = conflictsList;
            this.myInterfaceContainmentVerifier = interfaceContainmentVerifier;
        }

        @Override
        protected void visitMemberReference(@NotNull JSAttributeListOwner classMember, @NotNull JSReferenceExpression classMemberReference) {
            if (classMember == null) {
                NonAccessibleUsagesOfSubClassMembers.$$$reportNull$$$0(0);
            }
            if (classMemberReference == null) {
                NonAccessibleUsagesOfSubClassMembers.$$$reportNull$$$0(1);
            }
            if (JSPsiImplUtils.hasModifier(classMember, JSAttributeList.ModifierType.STATIC) && !this.willBeMoved((PsiElement)classMember)) {
                boolean isAccessible;
                if (this.mySuperClass != null) {
                    isAccessible = JSVisibilityUtil.isAccessible((PsiElement)classMember, (JSAttributeList)null, null, (PsiElement)this.mySuperClass, JSVisibilityUtil.DEFAULT_OPTIONS);
                } else {
                    boolean bl = isAccessible = classMember.getAttributeList() != null && classMember.getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC;
                }
                if (!isAccessible) {
                    String message = StringUtil.capitalize((String)RefactoringBundle.message((String)"0.uses.1.which.is.not.accessible.from.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)}));
                    this.myConflictsList.putValue((Object)classMember, (Object)message);
                }
            } else if (!(this.myAbstractMethods.contains(classMember) || this.willBeMoved((PsiElement)classMember) || this.existsInSuperClass(classMember))) {
                String message = StringUtil.capitalize((String)RefactoringBundle.message((String)"0.uses.1.which.is.not.moved.to.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)}));
                this.myConflictsList.putValue((Object)classMember, (Object)message);
            }
        }

        private boolean willBeMoved(PsiElement element) {
            for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
                if (!this.myMovedMembers.contains(parent)) continue;
                return true;
            }
            return false;
        }

        private boolean existsInSuperClass(JSElement classMember) {
            if (!(classMember instanceof JSFunction)) {
                return false;
            }
            JSFunction method = (JSFunction)classMember;
            if (this.myInterfaceContainmentVerifier.checkedInterfacesContain(method)) {
                return true;
            }
            if (this.mySuperClass == null) {
                return false;
            }
            return this.mySuperClass.findFunctionByName(method.getName()) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "classMember";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "classMemberReference";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpConflictsUtil$NonAccessibleUsagesOfSubClassMembers";
            objectArray[2] = "visitMemberReference";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

