/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.dialects.base.introspector.LevelAutoSelectionStrategy;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.Level;
import com.intellij.database.util.common.IntCouple;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/base/introspector/SimpleStrategy;", "Lcom/intellij/database/dialects/base/introspector/LevelAutoSelectionStrategy;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "selectSchemaLevel", "Lcom/intellij/database/model/properties/Level;", "schema", "Lcom/intellij/database/model/basic/BasicMultiLevelSchema;", "countSchemaObjectsInSchema", "Lcom/intellij/database/util/common/IntCouple;", "Lcom/intellij/database/model/basic/BasicSchema;", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nLevelAutoSelectionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LevelAutoSelectionStrategy.kt\ncom/intellij/database/dialects/base/introspector/SimpleStrategy\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,192:1\n18#2:193\n18#2:194\n14#2:195\n*S KotlinDebug\n*F\n+ 1 LevelAutoSelectionStrategy.kt\ncom/intellij/database/dialects/base/introspector/SimpleStrategy\n*L\n123#1:193\n124#1:194\n126#1:195\n*E\n"})
final class SimpleStrategy
extends LevelAutoSelectionStrategy {
    @NotNull
    private final String name;

    public SimpleStrategy() {
        super(null);
        this.name = "SIMPLE";
    }

    @Override
    @NotNull
    protected String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Level selectSchemaLevel(@NotNull BasicMultiLevelSchema schema) {
        void _true_$iv;
        void $this$choose$iv;
        int _true_$iv2;
        void $this$choose$iv2;
        int _true_$iv3;
        void $this$choose$iv3;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        String string = schema.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = string;
        boolean isSystem = (Boolean)this.isSchemaSystem().invoke((Object)schema);
        int isCurrent = schema.isCurrent();
        if (isSystem && isCurrent == 0) {
            this.trace("Auto-selected level L1 for schema " + name2 + " because this schema is system and not current");
            return Level.L1;
        }
        IntCouple intCouple = this.countSchemaObjectsInSchema(schema);
        int sco = intCouple.component1();
        int src = intCouple.component2();
        Level level = null;
        String reason = null;
        int n = isCurrent;
        int n2 = 3000;
        int _false_$iv = 300;
        boolean $i$f$choose = false;
        int limitSco = $this$choose$iv3 != false ? _true_$iv3 : _false_$iv;
        _true_$iv3 = isCurrent;
        _false_$iv = 500;
        int _false_$iv22 = 50;
        boolean $i$f$choose2 = false;
        int limitSrc = $this$choose$iv2 != false ? _true_$iv2 : _false_$iv22;
        _true_$iv2 = isCurrent;
        String _false_$iv22 = "current";
        String _false_$iv3 = "not current";
        boolean $i$f$choose3 = false;
        String w1 = $this$choose$iv != false ? _true_$iv : _false_$iv3;
        Object w2 = src > 0 ? "including " + src + " sources" : "without sources";
        String reasonPrefix = "schema is " + w1 + " and contains " + sco + " objects (" + (String)w2 + ")";
        if (sco <= limitSco) {
            if (src <= limitSrc) {
                level = Level.L3;
                reason = reasonPrefix + " that looks OK to retrieve them with sources";
            } else {
                level = Level.L2;
                reason = reasonPrefix + " that is better to retrieve on level 2";
            }
        } else {
            level = Level.L1;
            reason = reasonPrefix + " that is too many";
        }
        this.trace("Auto-selected level " + level + " for schema " + name2 + " because: " + reason);
        return level;
    }

    private final IntCouple countSchemaObjectsInSchema(BasicSchema schema) {
        int sco = 0;
        int src = 0;
        for (Family<? extends BasicElement> family : schema.getFamilies()) {
            if (!family.isNotEmpty()) continue;
            sco += family.size();
            BasicMetaObject<?> familyMetaObject = family.getMetaObject();
            Intrinsics.checkNotNull(familyMetaObject);
            if (ModelFun.isSourceAware(familyMetaObject)) {
                src += family.size();
            }
            Intrinsics.checkNotNullExpressionValue(familyMetaObject.children, (String)"children");
            List innerKinds = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])familyMetaObject.children), SimpleStrategy::countSchemaObjectsInSchema$lambda$0), SimpleStrategy::countSchemaObjectsInSchema$lambda$1));
            if (!(!((Collection)innerKinds).isEmpty())) continue;
            for (BasicElement basicElement : family) {
                for (ObjectKind innerKind : innerKinds) {
                    Family<? extends BasicElement> innerF = basicElement.familyOf(innerKind);
                    if (innerF == null) continue;
                    sco += innerF.size();
                    BasicMetaObject<?> basicMetaObject = innerF.getMetaObject();
                    Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
                    if (!ModelFun.isSourceAware(basicMetaObject)) continue;
                    src += innerF.size();
                }
            }
        }
        return new IntCouple(sco, src);
    }

    private static final boolean countSchemaObjectsInSchema$lambda$0(BasicMetaObject mc) {
        Intrinsics.checkNotNull((Object)mc);
        return ModelFun.isSchemaObject(mc);
    }

    private static final ObjectKind countSchemaObjectsInSchema$lambda$1(BasicMetaObject mc) {
        return mc.kind;
    }
}

