/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util.common;

import com.intellij.database.util.common.Conclusion;
import com.intellij.database.util.common.ConclusionBuilder;
import com.intellij.database.util.common.Objections;
import com.intellij.database.util.common.Okay;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a5\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u001d\u0010\u0004\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u001a3\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00020\u000b\"\u0004\u0018\u0001H\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"conclude", "Lcom/intellij/database/util/common/Conclusion;", "O", "", "action", "Lkotlin/Function1;", "Lcom/intellij/database/util/common/ConclusionBuilder;", "", "Lkotlin/ExtensionFunctionType;", "conclusionOf", "objections", "", "([Ljava/lang/Object;)Lcom/intellij/database/util/common/Conclusion;", "intellij.database.util"})
@JvmName(name="Conclusions")
public final class Conclusions {
    @NotNull
    public static final <O> Conclusion<O> conclude(@NotNull Function1<? super ConclusionBuilder<O>, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ConclusionBuilder b = new ConclusionBuilder();
        action.invoke(b);
        return b.conclusion();
    }

    @NotNull
    public static final <O> Conclusion<O> conclusionOf(O ... objections) {
        Intrinsics.checkNotNullParameter(objections, (String)"objections");
        List theObjections = ArraysKt.filterNotNull((Object[])objections);
        if (theObjections.isEmpty()) {
            return Okay.INSTANCE;
        }
        return new Objections(theObjections, false);
    }
}

