/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import org.jetbrains.annotations.NotNull;

public class SqlEnterHandlerImpl
extends EnterHandlerDelegateAdapter {
    private final SqlCloseBlockProcessor[] myProcessors;

    public SqlEnterHandlerImpl(SqlCloseBlockProcessor ... processors) {
        if (processors == null) {
            SqlEnterHandlerImpl.$$$reportNull$$$0(0);
        }
        this.myProcessors = processors;
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Project project;
        if (file == null) {
            SqlEnterHandlerImpl.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            SqlEnterHandlerImpl.$$$reportNull$$$0(2);
        }
        if (caretOffset == null) {
            SqlEnterHandlerImpl.$$$reportNull$$$0(3);
        }
        if (caretAdvance == null) {
            SqlEnterHandlerImpl.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            SqlEnterHandlerImpl.$$$reportNull$$$0(5);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!SqlEnterHandlerImpl.shouldHandle(editor2, dataContext)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
        PsiElement element = SqlEnterHandlerImpl.getWorkingElement(file, editor2);
        if (element == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        for (SqlCloseBlockProcessor processor2 : this.myProcessors) {
            if (!processor2.process(element, file, editor2, dataContext)) continue;
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static PsiElement getWorkingElement(@NotNull PsiFile file, @NotNull Editor editor2) {
        int caret;
        if (file == null) {
            SqlEnterHandlerImpl.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            SqlEnterHandlerImpl.$$$reportNull$$$0(7);
        }
        if ((caret = editor2.getCaretModel().getOffset()) == 0) {
            return null;
        }
        PsiElement elementAt = file.findElementAt(caret - 1);
        if (elementAt != null && StringUtil.isEmptyOrSpaces((String)elementAt.getText())) {
            elementAt = PsiTreeUtil.prevVisibleLeaf((PsiElement)elementAt);
        }
        return elementAt;
    }

    private static boolean shouldHandle(Editor editor2, DataContext dataContext) {
        if (editor2.isViewer()) {
            return false;
        }
        Document document = editor2.getDocument();
        return document.isWritable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processors";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/editor/SqlEnterHandlerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkingElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

