/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Spacing;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlPhraseBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlPhraseBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "tailFormed", "", "Companion", "intellij.database.sql.core.impl"})
public class SqlPhraseBlock
extends SqlRangeBlock {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<FlowPattern> patterns;

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        if (SqlFormattingModelFun.primaryElementType(block1) == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL && block2.getTextRange().getLength() == 1) {
            char lit = Character.toUpperCase(this.getContext().getText().charAt(block2.getRange().getStartOffset()));
            switch (lit) {
                case 'G': 
                case 'K': 
                case 'M': {
                    return SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null);
                }
            }
        }
        boolean gap = block1.getTextRange().getEndOffset() < block2.getTextRange().getStartOffset();
        return gap ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : this.getContext().makeNoSpace(false);
    }

    @Override
    public boolean tailFormed() {
        return true;
    }

    static {
        Object[] objectArray = new SingletonPattern[]{new SingletonPattern(null, null, NodeMatcherKt.matchAnyKeyword(), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE)), new SingletonPattern((byte)0, (byte)1, NodeMatcherKt.matchSingleText$default("exists", false, 2, null), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE))};
        patterns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlPhraseBlock$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

