/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.merge.MavenModelMerger;
import org.apache.maven.model.profile.ProfileInjector;

@Named
@Singleton
public class DefaultProfileInjector
implements ProfileInjector {
    private ProfileModelMerger merger = new ProfileModelMerger();

    @Override
    public void injectProfile(Model model, Profile profile, ModelBuildingRequest request2, ModelProblemCollector problems) {
        if (profile != null) {
            this.merger.mergeModelBase(model, profile);
            if (profile.getBuild() != null) {
                if (model.getBuild() == null) {
                    model.setBuild(new Build());
                }
                this.merger.mergeBuildBase(model.getBuild(), profile.getBuild());
            }
        }
    }

    protected static class ProfileModelMerger
    extends MavenModelMerger {
        protected ProfileModelMerger() {
        }

        public void mergeModelBase(ModelBase target2, ModelBase source) {
            this.mergeModelBase(target2, source, true, Collections.emptyMap());
        }

        public void mergeBuildBase(BuildBase target2, BuildBase source) {
            this.mergeBuildBase(target2, source, true, Collections.emptyMap());
        }

        @Override
        protected void mergePluginContainer_Plugins(PluginContainer target2, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List<Plugin> src = source.getPlugins();
            if (!src.isEmpty()) {
                List<Plugin> tgt = target2.getPlugins();
                LinkedHashMap<Iterator<Plugin>, Plugin> master = new LinkedHashMap<Iterator<Plugin>, Plugin>(tgt.size() * 2);
                for (Plugin element : tgt) {
                    Iterator<Plugin> key2 = this.getPluginKey(element);
                    master.put(key2, element);
                }
                LinkedHashMap predecessors = new LinkedHashMap();
                ArrayList<Plugin> pending = new ArrayList<Plugin>();
                for (Plugin element : src) {
                    Object key3 = this.getPluginKey(element);
                    Plugin existing2 = (Plugin)master.get(key3);
                    if (existing2 != null) {
                        this.mergePlugin(existing2, element, sourceDominant, context);
                        if (pending.isEmpty()) continue;
                        predecessors.put(key3, pending);
                        pending = new ArrayList();
                        continue;
                    }
                    pending.add(element.clone());
                }
                ArrayList<Plugin> result2 = new ArrayList<Plugin>(src.size() + tgt.size());
                for (Map.Entry entry : master.entrySet()) {
                    List pre = (List)predecessors.get(entry.getKey());
                    if (pre != null) {
                        result2.addAll(pre);
                    }
                    result2.add((Plugin)entry.getValue());
                }
                result2.addAll(pending);
                target2.setPlugins(result2);
            }
        }

        @Override
        protected void mergePlugin_Executions(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
            List<PluginExecution> src = source.getExecutions();
            if (!src.isEmpty()) {
                Object key2;
                List<PluginExecution> tgt = target2.getExecutions();
                LinkedHashMap<Object, PluginExecution> merged = new LinkedHashMap<Object, PluginExecution>((src.size() + tgt.size()) * 2);
                for (PluginExecution element : tgt) {
                    key2 = this.getPluginExecutionKey(element);
                    merged.put(key2, element);
                }
                for (PluginExecution element : src) {
                    key2 = this.getPluginExecutionKey(element);
                    PluginExecution existing2 = (PluginExecution)merged.get(key2);
                    if (existing2 != null) {
                        this.mergePluginExecution(existing2, element, sourceDominant, context);
                        continue;
                    }
                    merged.put(key2, element.clone());
                }
                target2.setExecutions(new ArrayList<PluginExecution>(merged.values()));
            }
        }

        @Override
        protected void mergeReporting_Plugins(Reporting target2, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
            List<ReportPlugin> src = source.getPlugins();
            if (!src.isEmpty()) {
                Object key2;
                List<ReportPlugin> tgt = target2.getPlugins();
                LinkedHashMap<Object, ReportPlugin> merged = new LinkedHashMap<Object, ReportPlugin>((src.size() + tgt.size()) * 2);
                for (ReportPlugin element : tgt) {
                    key2 = this.getReportPluginKey(element);
                    merged.put(key2, element);
                }
                for (ReportPlugin element : src) {
                    key2 = this.getReportPluginKey(element);
                    ReportPlugin existing2 = (ReportPlugin)merged.get(key2);
                    if (existing2 == null) {
                        merged.put(key2, element.clone());
                        continue;
                    }
                    this.mergeReportPlugin(existing2, element, sourceDominant, context);
                }
                target2.setPlugins(new ArrayList<ReportPlugin>(merged.values()));
            }
        }

        @Override
        protected void mergeReportPlugin_ReportSets(ReportPlugin target2, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
            List<ReportSet> src = source.getReportSets();
            if (!src.isEmpty()) {
                Object key2;
                List<ReportSet> tgt = target2.getReportSets();
                LinkedHashMap<Object, ReportSet> merged = new LinkedHashMap<Object, ReportSet>((src.size() + tgt.size()) * 2);
                for (ReportSet element : tgt) {
                    key2 = this.getReportSetKey(element);
                    merged.put(key2, element);
                }
                for (ReportSet element : src) {
                    key2 = this.getReportSetKey(element);
                    ReportSet existing2 = (ReportSet)merged.get(key2);
                    if (existing2 != null) {
                        this.mergeReportSet(existing2, element, sourceDominant, context);
                        continue;
                    }
                    merged.put(key2, element.clone());
                }
                target2.setReportSets(new ArrayList<ReportSet>(merged.values()));
            }
        }
    }
}

