/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.PercentageParser;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.ColumnInfo;
import java.util.Comparator;

public final class PercentageCoverageColumnInfo
extends ColumnInfo<NodeDescriptor<?>, String> {
    private final int myColumnIdx;
    private final Comparator<NodeDescriptor<?>> myComparator;
    private final CoverageSuitesBundle mySuitesBundle;

    @Deprecated(forRemoval=true)
    public PercentageCoverageColumnInfo(int columnIdx, @NlsContexts.ColumnName String name, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        this(columnIdx, name, suitesBundle);
    }

    public PercentageCoverageColumnInfo(int columnIdx, @NlsContexts.ColumnName String name, CoverageSuitesBundle suitesBundle) {
        super(name);
        this.myColumnIdx = columnIdx;
        this.myComparator = (o1, o2) -> {
            String val1 = this.valueOf((NodeDescriptor)o1);
            String val2 = this.valueOf((NodeDescriptor)o2);
            if (val1 == null || val2 == null) {
                return Comparing.compare((Comparable)((Object)val1), (Comparable)((Object)val2));
            }
            return PercentageParser.parse(val1).compareTo(PercentageParser.parse(val2));
        };
        this.mySuitesBundle = suitesBundle;
    }

    public String valueOf(NodeDescriptor node) {
        Project project;
        CoverageEngine coverageEngine = this.mySuitesBundle.getCoverageEngine();
        CoverageViewExtension extension = coverageEngine.createCoverageViewExtension(project = node.getProject(), this.mySuitesBundle);
        if (extension == null) {
            return null;
        }
        return extension.getPercentage(this.myColumnIdx, (AbstractTreeNode)node);
    }

    public Comparator<NodeDescriptor<?>> getComparator() {
        return this.myComparator;
    }
}

