/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\b"}, d2={"getPathMatcher", "Ljava/nio/file/PathMatcher;", "globPattern", "", "ignorePatternSyntaxException", "", "transformIntoJdkFriendlyGlobs", "", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nglobUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 globUtil.kt\ncom/intellij/openapi/util/GlobUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1611#2,9:87\n1863#2:96\n1864#2:98\n1620#2:99\n1755#2,3:100\n1#3:97\n*S KotlinDebug\n*F\n+ 1 globUtil.kt\ncom/intellij/openapi/util/GlobUtilKt\n*L\n39#1:87,9\n39#1:96\n39#1:98\n39#1:99\n48#1:100,3\n39#1:97\n*E\n"})
public final class GlobUtilKt {
    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final PathMatcher getPathMatcher(@NotNull String globPattern, boolean ignorePatternSyntaxException) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(globPattern, "globPattern");
        List<String> patterns = GlobUtilKt.transformIntoJdkFriendlyGlobs(StringsKt.removePrefix(globPattern, (CharSequence)"glob:"));
        Iterable $this$mapNotNull$iv = patterns;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PathMatcher it$iv$iv;
            PathMatcher pathMatcher;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + it);
            }
            catch (PatternSyntaxException e) {
                if (!ignorePatternSyntaxException) {
                    throw e;
                }
                pathMatcher = null;
            }
            if (pathMatcher == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List matchers = (List)destination$iv$iv;
        return matchers.size() == 1 ? (PathMatcher)matchers.get(0) : arg_0 -> GlobUtilKt.getPathMatcher$lambda$2(matchers, arg_0);
    }

    public static /* synthetic */ PathMatcher getPathMatcher$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return GlobUtilKt.getPathMatcher(string, bl);
    }

    private static final List<String> transformIntoJdkFriendlyGlobs(String globPattern) {
        String string;
        int braceIndex = StringsKt.indexOf$default((CharSequence)globPattern, '{', 0, false, 6, null);
        if (braceIndex == -1) {
            string = globPattern;
        } else {
            String string2 = globPattern.substring(0, braceIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        }
        String globBeforeBrace = string;
        String string3 = globPattern.substring(globBeforeBrace.length());
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        String globTail = string3;
        String fixedGlobBeforeBrace = StringsKt.replace$default(globBeforeBrace, "**/", "{**/,}", false, 4, null);
        String[] stringArray = new String[]{fixedGlobBeforeBrace + globTail};
        List<String> result2 = CollectionsKt.mutableListOf(stringArray);
        int globstarIndex = StringsKt.indexOf$default((CharSequence)globTail, "**/", 0, false, 6, null);
        int globstarsInTail = 0;
        while (globstarIndex >= 0) {
            ++globstarsInTail;
            String string4 = globTail;
            int n = globstarIndex + 3;
            CharSequence charSequence = "";
            result2.add(fixedGlobBeforeBrace + ((Object)StringsKt.replaceRange((CharSequence)string4, globstarIndex, n, charSequence)).toString());
            globstarIndex = StringsKt.indexOf$default((CharSequence)globTail, "**/", globstarIndex + 1, false, 4, null);
        }
        if (globstarsInTail > 1) {
            result2.add(fixedGlobBeforeBrace + StringsKt.replace$default(globTail, "**/", "", false, 4, null));
        }
        return result2;
    }

    private static final boolean getPathMatcher$lambda$2(List $matchers, Path path) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(path, "path");
            Iterable $this$any$iv = $matchers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PathMatcher it = (PathMatcher)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(path)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

