/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.util.DockerUtil;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerImageDeploymentSourceType
extends DockerSingletonDeploymentSourceType {
    static final String ID = "docker-image";

    public static DockerImageDeploymentSourceType getInstance() {
        return (DockerImageDeploymentSourceType)DockerImageDeploymentSourceType.findExtension(DockerImageDeploymentSourceType.class);
    }

    public DockerImageDeploymentSourceType() {
        super(ID, DockerBundle.message("DockerImageDeploymentSourceType.name", new Object[0]), DockerIcons.SingleImage);
    }

    @Override
    @NotNull
    public String getPresentableDeploymentName(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerRuntimeBase runtime) {
        if (configuration == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(0);
        }
        String namePiece = DockerImageDeploymentSourceType.getPresentableContainerNamePiece(configuration, runtime);
        if (runtime != null) {
            String string = namePiece;
            if (string == null) {
                DockerImageDeploymentSourceType.$$$reportNull$$$0(1);
            }
            return string;
        }
        String firstTagOrId = (String)ArrayUtil.getFirstElement((Object[])configuration.getSeparateImageTags());
        String shortTag = StringUtil.isEmptyOrSpaces((String)firstTagOrId) ? "" : DockerUtil.shortedId(firstTagOrId);
        String string = DockerBundle.message("DockerImageDeploymentSourceType.deploymentName", namePiece, shortTag);
        if (string == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String suggestConfigurationName(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(3);
        }
        return DockerBundle.message("DockerImageDeploymentSourceType.suggestRunConfigurationName", new Object[0]);
    }

    @Override
    public void checkDeploymentConfiguration(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) throws RuntimeConfigurationException {
        if (project == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(5);
        }
        super.checkDeploymentConfiguration(project, configuration);
        String[] tags = configuration.getSeparateImageTags();
        if (tags.length == 0) {
            throw new RuntimeConfigurationError(DockerBundle.message("DockerImageDeploymentSourceType.error.image.id.required", new Object[0]));
        }
        DockerImageDeploymentSourceType.checkImageTagFormat(configuration, true, true);
        DockerImageDeploymentSourceType.checkContainerNameFormat(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deploymentSource/DockerImageDeploymentSourceType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deploymentSource/DockerImageDeploymentSourceType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDeploymentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableDeploymentName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkDeploymentConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

