/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vswin.utilities;

import com.intellij.ide.startup.importSettings.db.WindowsEnvVariables;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSRegistryParserNew;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.RunConfigurationEnvironmentUtils;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHive;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSProfileDetectorUtils;", "", "<init>", "()V", "vsInstallDir", "", "vsLocation", "userProfile", "localAppdata", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "expandPath", "str", "hive", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "rootSuffixStabilizer", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSProfileDetectorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSProfileDetectorUtils.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSProfileDetectorUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,41:1\n15#2:42\n*S KotlinDebug\n*F\n+ 1 VSProfileDetectorUtils.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSProfileDetectorUtils\n*L\n16#1:42\n*E\n"})
public final class VSProfileDetectorUtils {
    @NotNull
    public static final VSProfileDetectorUtils INSTANCE = new VSProfileDetectorUtils();
    @NotNull
    public static final String vsInstallDir = "vsspv_vs_install_directory";
    @NotNull
    private static final String vsLocation = "vsspv_visualstudio_dir";
    @NotNull
    private static final String userProfile = "vsspv_user_appdata";
    @NotNull
    private static final String localAppdata = "vsspv_vs_localappdata_dir";
    @NotNull
    private static final Logger logger;

    private VSProfileDetectorUtils() {
    }

    @Nullable
    public final String expandPath(@NotNull String str, @NotNull VSHive hive) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)hive, (String)"hive");
        String localAppDataLoc = WindowsEnvVariables.INSTANCE.getLocalApplicationData() + "\\Microsoft\\VisualStudio\\" + hive.getHiveString();
        Pair[] pairArray = new Pair[3];
        VSRegistryParserNew vSRegistryParserNew = hive.getRegistry();
        pairArray[0] = TuplesKt.to((Object)vsLocation, (Object)(vSRegistryParserNew != null ? vSRegistryParserNew.getVsLocation() : null));
        pairArray[1] = TuplesKt.to((Object)localAppdata, (Object)localAppDataLoc);
        pairArray[2] = TuplesKt.to((Object)userProfile, (Object)WindowsEnvVariables.INSTANCE.getUserProfile());
        Map map = MapsKt.mapOf((Pair[])pairArray);
        String preExp = RunConfigurationEnvironmentUtils.INSTANCE.expandVariables(str, map, MapsKt.emptyMap());
        if (preExp == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return WindowsEnvVariables.INSTANCE.expandPath(preExp);
    }

    @Nullable
    public final String rootSuffixStabilizer(@NotNull VSHive hive) {
        Intrinsics.checkNotNullParameter((Object)hive, (String)"hive");
        String string = hive.getRootSuffix();
        if (string == null) {
            return null;
        }
        String rootSuffix = string;
        String string2 = rootSuffix.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return Intrinsics.areEqual((Object)string2, (Object)"exp") ? "Experimental" : rootSuffix;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VSProfileDetectorUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VSProfileDetectorUtils.logger = logger;
    }
}

