/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.ServerBrowserTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.CancellableAllFileSelector;
import com.jetbrains.plugins.webDeployment.ui.PermissionsDialog;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;

public class SetPermissionsAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(SetPermissionsAction.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SetPermissionsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SetPermissionsAction.$$$reportNull$$$0(1);
        }
        boolean enabled = SetPermissionsAction.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(enabled);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        if ("RemoteHostDialogPopup".equals(e.getPlace())) {
            return false;
        }
        Deployable server = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
        ServerTreeNode[] selectedNodes = (ServerTreeNode[])e.getData(WebDeploymentDataKeys.SERVER_NODES);
        if (server == null || selectedNodes == null || !server.getAccessType().isProtocolBased() || server.validateFast() != null) {
            return false;
        }
        FileObject[] files = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (files == null || files.length == 0) {
            return false;
        }
        return selectedNodes.length > 0 && !server.getAccessType().equals((Object)AccessType.WEBDAV);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        String dialogTitle;
        if (e == null) {
            SetPermissionsAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        final Deployable serverConfig = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
        FileObject[] items = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (project == null || serverConfig == null || items == null) {
            return;
        }
        final RemoteConnection connection = (RemoteConnection)e.getData(WebDeploymentDataKeys.REMOTE_CONNECTION);
        if (connection == null) {
            return;
        }
        ServerTree parentComponent = (ServerTree)((Object)e.getData(WebDeploymentDataKeys.SERVER_TREE));
        Ref needFolders = new Ref((Object)false);
        @NlsContexts.DialogMessage Ref error = new Ref();
        Ref firstItemPermissions = new Ref();
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            connection.executeServerOperationSilently(() -> {
                for (FileObject item : items) {
                    pi.checkCanceled();
                    try {
                        if (firstItemPermissions.isNull()) {
                            firstItemPermissions.set((Object)(item.getPermissions() & 0x1FF));
                        }
                        if (item.getType() != FileType.FOLDER) continue;
                        needFolders.set((Object)true);
                        break;
                    }
                    catch (FileSystemException e1) {
                        LOG.warn((Throwable)e1);
                        error.set((Object)WDBundle.message("failed.to.read.items.types", PublishUtils.getMessage(e1, false)));
                    }
                }
            }, pi);
        }, WDBundle.message("set.permissions.task.text", new Object[0]), true, project);
        if (!completed) {
            return;
        }
        if (!error.isNull()) {
            Messages.showErrorDialog((Project)project, (String)((String)error.get()), (String)WDBundle.message("set.permissions.task.title", new Object[0]));
            return;
        }
        int filesPermissions = 420;
        int foldersPermissions = 493;
        if (items.length == 1 && !((Boolean)needFolders.get()).booleanValue()) {
            String name = items[0].getName().getBaseName();
            if (name.isEmpty()) {
                name = "/";
            }
            dialogTitle = WDBundle.message("set.permissions.dialog.title.single", (Boolean)needFolders.get() != false ? 2 : 1, name);
            filesPermissions = (Integer)firstItemPermissions.get();
        } else {
            dialogTitle = WDBundle.message("set.permissions.dialog.title.multiple", (Boolean)needFolders.get() != false ? 2 : 1);
            if (items.length == 1) {
                foldersPermissions = (Integer)firstItemPermissions.get();
            }
        }
        if (((Boolean)needFolders.get()).booleanValue()) {
            d = new PermissionsDialog.Tabs((Component)((Object)parentComponent), dialogTitle, filesPermissions, foldersPermissions);
            if (!d.showAndGet()) {
                return;
            }
            filesPermissions = ((PermissionsDialog.Tabs)d).getFilesPermissions();
            foldersPermissions = ((PermissionsDialog.Tabs)d).getFoldersPermissions();
        } else {
            d = new PermissionsDialog.Single((Component)((Object)parentComponent), dialogTitle, filesPermissions);
            if (!d.showAndGet()) {
                return;
            }
            filesPermissions = ((PermissionsDialog.Single)d).getPermissions();
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project).clone();
        publishConfig.setFilePermissions(filesPermissions);
        publishConfig.setFolderPermissions(foldersPermissions);
        final DistinctRootsCollections.FileObjects roots = new DistinctRootsCollections.FileObjects(items);
        new ServerBrowserTask(project, ConnectionOwnerFactory.createConnectionOwner(project), publishConfig, serverConfig, WDBundle.message("set.permissions.task.text", new Object[0]), DeploymentRevisionTracker.DEAF, true){

            @Override
            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                ArrayList<TransferOperation.ChangePermissions> result = new ArrayList<TransferOperation.ChangePermissions>();
                DeploymentPathUtils.ErrorsAndExclusions errorsAndExclusions = new DeploymentPathUtils.ErrorsAndExclusions();
                Iterator iterator = roots.iterator();
                while (iterator.hasNext()) {
                    FileObject root = (FileObject)iterator.next();
                    DeploymentPathUtils.refreshRemoteFile(root, context);
                    if (!root.exists()) {
                        String message = WDBundle.message("remote.item.does.not.exist", serverConfig.getPresentablePath(root));
                        if (roots.size() == 1) {
                            throw new CustomFileSystemException(message);
                        }
                        errorsAndExclusions.addError(message);
                    }
                    ArrayList<FileObject> children = new ArrayList<FileObject>();
                    try {
                        root.findFiles(new CancellableAllFileSelector(context.getProgressIndicator(), "processing.0", true), true, children);
                    }
                    catch (FileSystemException e) {
                        LOG.warn((Throwable)e);
                        if (roots.size() == 1 || PublishUtils.isFatal(e)) {
                            throw e;
                        }
                        errorsAndExclusions.addError(PublishUtils.getMessage(e, false));
                    }
                    for (FileObject child : children) {
                        context.getProgressIndicator().checkCanceled();
                        result.add(new TransferOperation.ChangePermissions(child));
                    }
                }
                return new TransferTask.ListBased.ResultWithErrors(result, errorsAndExclusions);
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/SetPermissionsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/SetPermissionsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

