/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;

public class KeepingSelectionExpander
implements Expander {
    private final JTree myTree;
    private TreePath mySelectionPath;

    public KeepingSelectionExpander(RepositoryBrowserComponent browser) {
        this.myTree = browser.getRepositoryTree();
    }

    @Override
    public void onBeforeRefresh(RepositoryTreeNode node) {
        this.mySelectionPath = this.myTree.getSelectionPath();
    }

    @Override
    public void onAfterRefresh(RepositoryTreeNode node) {
        if (this.mySelectionPath == null) {
            return;
        }
        this.setSelection(this.mySelectionPath.getPath(), 1, (TreeNode)this.myTree.getModel().getRoot());
    }

    private boolean setSelection(Object[] oldSelectionPath, int idx, TreeNode node) {
        if (idx >= oldSelectionPath.length) {
            return false;
        }
        if (oldSelectionPath[idx] != null && oldSelectionPath[idx].toString() != null) {
            Enumeration<? extends TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (!oldSelectionPath[idx].toString().equals(child.toString())) continue;
                boolean childStatus = this.setSelection(oldSelectionPath, idx + 1, child);
                if (!childStatus) {
                    this.myTree.setSelectionPath(new TreePath(((DefaultTreeModel)this.myTree.getModel()).getPathToRoot(child)));
                }
                return true;
            }
        }
        this.myTree.setSelectionPath(new TreePath(((DefaultTreeModel)this.myTree.getModel()).getPathToRoot(node)));
        return true;
    }
}

