/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.parser;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.python.pro.cython.CythonNames;
import com.intellij.python.pro.cython.parser.CythonTokenTypes;
import com.intellij.python.pro.cython.psi.elementTypes.CythonElementTypes;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyParsingBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CythonDeclParsing
extends Parsing {
    @NonNls
    protected static final String INLINE_TOKEN = "inline";
    @NonNls
    protected static final String GIL_TOKEN = "gil";
    @NonNls
    protected static final String NOGIL_TOKEN = "nogil";
    @NonNls
    protected static final String CONST_TOKEN = "const";
    @NonNls
    protected static final String COMPLEX_TOKEN = "complex";

    protected CythonDeclParsing(ParsingContext context) {
        super(context);
    }

    protected IElementType getReferenceType() {
        return CythonElementTypes.REFERENCE_EXPRESSION;
    }

    protected List<String> parseVisibilityDecl() {
        String s;
        ArrayList<String> toks = new ArrayList<String>();
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER) && CythonNames.VISIBILITY_MODIFIERS.contains((Object)(s = this.myContext.getBuilder().getTokenText()))) {
            toks.add(s);
            this.nextToken();
        }
        return toks;
    }

    protected boolean parseApiDecl() {
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, "api")) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected void parseInlineDecl() {
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, INLINE_TOKEN)) {
            this.nextToken();
        }
    }

    protected DeclaratorType parseNameDecl(boolean requireEmpty, boolean requireNonEmpty, boolean assignable) {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker marker = builder.mark();
        DeclaratorType type = DeclaratorType.EMPTY;
        DeclaratorType simpleType = DeclaratorType.EMPTY;
        if (this.atToken((IElementType)PyTokenTypes.LPAR)) {
            SyntaxTreeBuilder.Marker paramList = builder.mark();
            this.nextToken();
            if (this.atToken((IElementType)PyTokenTypes.RPAR) || this.atToken((IElementType)PyTokenTypes.IDENTIFIER) && !CythonNames.CALLING_CONVENTIONS.contains((Object)builder.getTokenText())) {
                paramList.rollbackTo();
                this.parseCdefFunctionParameters();
                type = DeclaratorType.FUNCTION;
            } else {
                paramList.drop();
                this.parseNameDecl(requireEmpty, requireNonEmpty, assignable);
                this.checkMatches((IElementType)PyTokenTypes.RPAR, PyParsingBundle.message((String)"PARSE.expected.rpar", (Object[])new Object[0]));
                type = DeclaratorType.VARIABLE;
            }
        } else {
            simpleType = this.parseSimpleNameDecl(requireEmpty, requireNonEmpty, assignable);
            if (simpleType == DeclaratorType.EMPTY) {
                marker.drop();
                return simpleType;
            }
        }
        while (this.atAnyOfTokens(new IElementType[]{PyTokenTypes.LBRACKET, PyTokenTypes.LPAR})) {
            if (this.atToken((IElementType)PyTokenTypes.LBRACKET)) {
                this.parseArrayDecl();
                if (type != DeclaratorType.EMPTY) continue;
                type = DeclaratorType.VARIABLE;
                continue;
            }
            this.parseCdefFunctionParameters();
            if (type != DeclaratorType.EMPTY) continue;
            type = DeclaratorType.FUNCTION;
        }
        marker.done((IElementType)CythonElementTypes.NAME_DECL);
        return type != DeclaratorType.EMPTY ? type : simpleType;
    }

    private void parseCdefFunctionParameters() {
        FunctionParsing parser2 = this.getFunctionParser();
        parser2.parseParameterList();
        parser2.parseReturnTypeAnnotation();
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        this.parseNoGilDecl();
        this.parseExceptionDecl();
        if (this.atToken((IElementType)PyTokenTypes.WITH_KEYWORD)) {
            this.nextToken();
            if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, GIL_TOKEN)) {
                this.nextToken();
            } else {
                builder.error(PyParsingBundle.message((String)"PARSE.0.expected", (Object[])new Object[]{GIL_TOKEN}));
            }
        }
    }

    protected boolean parseNoGilDecl() {
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, NOGIL_TOKEN)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private void parseArrayDecl() {
        this.assertCurrentToken(PyTokenTypes.LBRACKET);
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker marker = builder.mark();
        this.nextToken();
        if (!this.atToken((IElementType)PyTokenTypes.RBRACKET)) {
            this.getExpressionParser().parseExpression();
        }
        this.checkMatches((IElementType)PyTokenTypes.RBRACKET, PyParsingBundle.message((String)"PARSE.expected.rbracket", (Object[])new Object[0]));
        marker.done((IElementType)CythonElementTypes.ARRAY_DECL);
    }

    private void parseExceptionDecl() {
        if (this.atToken((IElementType)PyTokenTypes.EXCEPT_KEYWORD)) {
            SyntaxTreeBuilder builder = this.myContext.getBuilder();
            SyntaxTreeBuilder.Marker marker = builder.mark();
            this.nextToken();
            if (this.atToken((IElementType)PyTokenTypes.MULT)) {
                this.nextToken();
            } else if (this.atToken((IElementType)PyTokenTypes.PLUS)) {
                this.nextToken();
                if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
                    this.getParsingContext().getExpressionParser().parseExpression();
                }
            } else {
                if (this.atToken((IElementType)CythonTokenTypes.QUESTION)) {
                    this.nextToken();
                }
                this.getExpressionParser().parseSingleExpression(false);
            }
            marker.done((IElementType)CythonElementTypes.EXCEPTION_DECL);
        }
    }

    private DeclaratorType parseSimpleNameDecl(boolean requireEmpty, boolean requireNonEmpty, boolean assignable) {
        this.parseCallingConventionDecl();
        if (this.atAnyOfTokens(new IElementType[]{PyTokenTypes.MULT, PyTokenTypes.EXP})) {
            this.nextToken();
            DeclaratorType type = this.parseNameDecl(requireEmpty, requireNonEmpty, assignable);
            return type != DeclaratorType.EMPTY ? type : DeclaratorType.VARIABLE;
        }
        if (this.atToken((IElementType)PyTokenTypes.AND)) {
            this.nextToken();
            return this.parseNameDecl(requireEmpty, requireNonEmpty, assignable);
        }
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker assignment = builder.mark();
        SyntaxTreeBuilder.Marker target = builder.mark();
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
            if (requireEmpty) {
                builder.error(PyParsingBundle.message((String)"PARSE.declarator.should.be.empty", (Object[])new Object[0]));
            }
            if ("operator".equals(builder.getTokenText()) && requireNonEmpty) {
                this.nextToken();
                String firstTokenText = builder.getTokenText();
                ImmutableSet firstOpChars = ImmutableSet.of((Object)"+", (Object)"-", (Object)"*", (Object)"/", (Object)"<", (Object)"=", (Object[])new String[]{">", "!", "%", "&", "|", "(", "[", "^", "~", ",", "+=", "-=", "*=", "/=", "<=", "==", ">=", "!=", "%=", "&=", "|=", "^="});
                if (firstOpChars.contains((Object)firstTokenText)) {
                    this.nextToken();
                    String secondTokenText = builder.getTokenText();
                    if ("(".equals(firstTokenText)) {
                        this.checkMatches(")", PyParsingBundle.message((String)"PARSE.expected.rpar", (Object[])new Object[0]));
                    } else if ("[".equals(firstTokenText)) {
                        this.checkMatches("]", PyParsingBundle.message((String)"PARSE.expected.rbracket", (Object[])new Object[0]));
                    } else if (ImmutableSet.of((Object)"+", (Object)"-", (Object)"|", (Object)"&").contains((Object)firstTokenText) && firstTokenText != null && firstTokenText.equals(secondTokenText)) {
                        this.nextToken();
                    } else if ("=".equals(secondTokenText) && "~".equals(firstTokenText)) {
                        this.nextToken();
                    }
                }
                target.drop();
                assignment.drop();
                return DeclaratorType.VARIABLE;
            }
            this.nextToken();
            this.parseCanonicalName();
            if (this.atToken((IElementType)PyTokenTypes.EQ) && assignable) {
                target.done(PyElementTypes.TARGET_EXPRESSION);
                this.nextToken();
                this.getExpressionParser().parseSingleExpression(false);
                assignment.done((IElementType)PyElementTypes.ASSIGNMENT_STATEMENT);
            } else {
                target.drop();
                assignment.drop();
            }
            return DeclaratorType.VARIABLE;
        }
        target.drop();
        assignment.drop();
        if (requireNonEmpty) {
            builder.error(PyParsingBundle.message((String)"PARSE.expected.identifier", (Object[])new Object[0]));
        }
        return DeclaratorType.EMPTY;
    }

    private void parseCallingConventionDecl() {
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER) && CythonNames.CALLING_CONVENTIONS.contains((Object)this.myBuilder.getTokenText())) {
            CythonDeclParsing.buildTokenElement((IElementType)CythonElementTypes.CALLING_CONVENTION_DECL, (SyntaxTreeBuilder)this.myBuilder);
        }
    }

    protected void parseCanonicalName() {
        this.getExpressionParser().parseStringLiteralExpression();
    }

    protected void parseBaseTypeDecl(boolean requireNonEmpty) {
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, CONST_TOKEN) && this.myContext.getBuilder().lookAhead(1) == PyTokenTypes.LPAR) {
            this.nextToken();
        }
        if (this.atToken((IElementType)PyTokenTypes.LPAR)) {
            this.parseComplexBaseTypeDecl();
        } else {
            this.parseSimpleBaseTypeDecl(requireNonEmpty);
        }
    }

    private void parseComplexBaseTypeDecl() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker marker = builder.mark();
        this.nextToken();
        this.parseBaseTypeDecl(false);
        SyntaxTreeBuilder.Marker afterType = builder.mark();
        this.parseNameDecl(true, false, false);
        if (this.atToken((IElementType)PyTokenTypes.COMMA)) {
            afterType.rollbackTo();
            while (this.atAnyOfTokens(new IElementType[]{PyTokenTypes.MULT, PyTokenTypes.EXP})) {
                this.nextToken();
            }
            while (this.atToken((IElementType)PyTokenTypes.COMMA)) {
                this.nextToken();
                if (this.atToken((IElementType)PyTokenTypes.RPAR)) {
                    this.nextToken();
                    marker.done((IElementType)CythonElementTypes.COMPLEX_BASE_TYPE_DECL);
                    return;
                }
                this.parseBaseTypeDecl(false);
                while (this.atAnyOfTokens(new IElementType[]{PyTokenTypes.MULT, PyTokenTypes.EXP})) {
                    this.nextToken();
                }
            }
        } else {
            afterType.drop();
        }
        this.checkMatches((IElementType)PyTokenTypes.RPAR, PyParsingBundle.message((String)"PARSE.expected.rpar", (Object[])new Object[0]));
        marker.done((IElementType)CythonElementTypes.COMPLEX_BASE_TYPE_DECL);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseSimpleBaseTypeDecl(boolean requireNonEmpty) {
        SyntaxTreeBuilder.Marker marker;
        block22: {
            SyntaxTreeBuilder builder;
            block23: {
                builder = this.myContext.getBuilder();
                if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, CONST_TOKEN)) {
                    this.nextToken();
                }
                marker = builder.mark();
                if (!this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
                    builder.error(PyParsingBundle.message((String)"PARSE.expected.identifier", (Object[])new Object[0]));
                    this.nextToken();
                    marker.drop();
                    return;
                }
                if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, CONST_TOKEN)) {
                    this.nextToken();
                }
                if (!this.atBaseTypeToken()) break block23;
                if (CythonNames.BASE_CYTHON_TYPES.contains((Object)builder.getTokenText())) {
                    this.nextToken();
                    break block22;
                } else {
                    while (this.atToken((IElementType)PyTokenTypes.IDENTIFIER) && CythonNames.BASE_TYPE_MODIFIERS.contains((Object)builder.getTokenText())) {
                        this.nextToken();
                    }
                    if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER) && CythonNames.BASE_C_TYPES.contains((Object)builder.getTokenText())) {
                        this.nextToken();
                    }
                    if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER, COMPLEX_TOKEN)) {
                        this.nextToken();
                    }
                }
                break block22;
            }
            if (this.atDottedName()) {
                this.parseDottedName();
            } else {
                SyntaxTreeBuilder.Marker ref = builder.mark();
                this.nextToken();
                if (requireNonEmpty && !this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
                    if (this.atToken((IElementType)PyTokenTypes.LPAR)) {
                        SyntaxTreeBuilder.Marker atLeftParen = builder.mark();
                        this.nextToken();
                        if (!this.atAnyOfTokens(new IElementType[]{PyTokenTypes.MULT, PyTokenTypes.EXP, PyTokenTypes.AND})) {
                            ref.drop();
                            atLeftParen.drop();
                            marker.rollbackTo();
                            return;
                        }
                        ref.drop();
                        atLeftParen.rollbackTo();
                    } else {
                        if (!this.atAnyOfTokens(new IElementType[]{PyTokenTypes.MULT, PyTokenTypes.EXP, PyTokenTypes.LBRACKET, PyTokenTypes.AND})) {
                            ref.drop();
                            marker.rollbackTo();
                            return;
                        }
                        ref.done(this.getReferenceType());
                    }
                } else {
                    ref.done(this.getReferenceType());
                }
            }
        }
        if (this.atToken((IElementType)PyTokenTypes.LBRACKET)) {
            if (this.atMemoryView()) {
                this.parseMemoryView();
            } else {
                while (this.atToken((IElementType)PyTokenTypes.LBRACKET)) {
                    this.parseTypeParametersDecl();
                }
            }
        }
        if (this.atToken((IElementType)PyTokenTypes.DOT)) {
            this.nextToken();
            this.parseIdentifier();
        }
        if (this.atToken((IElementType)PyTokenTypes.MULT)) {
            this.nextToken();
        }
        marker.done((IElementType)CythonElementTypes.SIMPLE_BASE_TYPE_DECL);
    }

    private void parseMemoryView() {
        SyntaxTreeBuilder.Marker exprStart = this.myBuilder.mark();
        this.nextToken();
        SyntaxTreeBuilder.Marker sliceItemStart = this.myBuilder.mark();
        ExpressionParsing parser2 = this.getParsingContext().getExpressionParser();
        parser2.parseSliceEnd(exprStart, sliceItemStart);
    }

    private boolean atMemoryView() {
        boolean result = false;
        SyntaxTreeBuilder.Marker marker = this.myContext.getBuilder().mark();
        this.nextToken();
        if (this.atToken((IElementType)PyTokenTypes.INTEGER_LITERAL)) {
            this.nextToken();
        }
        if (this.atToken((IElementType)PyTokenTypes.COLON)) {
            result = true;
        }
        marker.rollbackTo();
        return result;
    }

    private void parseTypeParametersDecl() {
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        this.parsePositionalAndKeywordArgs();
        this.checkMatches((IElementType)PyTokenTypes.RBRACKET, PyParsingBundle.message((String)"PARSE.expected.rbracket", (Object[])new Object[0]));
        marker.done(PyElementTypes.PARAMETER_LIST);
    }

    private void parsePositionalAndKeywordArgs() {
        while (!this.atToken((IElementType)PyTokenTypes.RBRACKET)) {
            SyntaxTreeBuilder.Marker namedParameter = this.myBuilder.mark();
            SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
            if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
                this.nextToken();
                if (this.atToken((IElementType)PyTokenTypes.EQ)) {
                    this.nextToken();
                    marker.drop();
                } else {
                    marker.rollbackTo();
                }
            } else {
                marker.rollbackTo();
            }
            if (this.atExpression()) {
                this.getExpressionParser().parseSingleExpression(false);
            } else {
                SyntaxTreeBuilder.Marker typeDecl = this.myBuilder.mark();
                this.parseBaseTypeDecl(true);
                this.parseNameDecl(true, false, false);
                typeDecl.done((IElementType)CythonElementTypes.COMPLEX_BASE_TYPE_DECL);
            }
            namedParameter.done((IElementType)CythonElementTypes.NAMED_PARAMETER);
            if (!this.atToken((IElementType)PyTokenTypes.COMMA)) {
                if (this.atToken((IElementType)PyTokenTypes.RBRACKET)) break;
                this.myBuilder.error(PyParsingBundle.message((String)"PARSE.expected.symbols", (Object[])new Object[]{",", "]"}));
                break;
            }
            this.nextToken();
        }
    }

    private void parseDottedName() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker expr = builder.mark();
        this.assertCurrentToken(PyTokenTypes.IDENTIFIER);
        CythonDeclParsing.buildTokenElement((IElementType)this.getReferenceType(), (SyntaxTreeBuilder)builder);
        while (this.atToken((IElementType)PyTokenTypes.DOT)) {
            this.nextToken();
            this.parseIdentifier();
            expr.done(this.getReferenceType());
            expr = expr.precede();
        }
        expr.drop();
    }

    protected boolean atExpression() {
        if (this.atBaseTypeToken()) {
            return false;
        }
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
            boolean isType = false;
            SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
            this.nextToken();
            while (this.atToken((IElementType)PyTokenTypes.DOT)) {
                this.nextToken();
                this.parseIdentifier();
            }
            if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
                isType = true;
            } else if (this.atAnyOfTokens(new IElementType[]{PyTokenTypes.MULT, PyTokenTypes.EXP})) {
                this.nextToken();
                isType = this.atAnyOfTokens(new IElementType[]{PyTokenTypes.RPAR, PyTokenTypes.RBRACKET});
            } else if (this.atToken((IElementType)PyTokenTypes.LPAR)) {
                this.nextToken();
                isType = this.atToken((IElementType)PyTokenTypes.MULT);
            } else if (this.atToken((IElementType)PyTokenTypes.LBRACKET)) {
                this.nextToken();
                isType = this.atToken((IElementType)PyTokenTypes.RBRACKET);
            }
            marker.rollbackTo();
            return !isType;
        }
        return true;
    }

    private boolean atDottedName() {
        boolean result = false;
        SyntaxTreeBuilder.Marker marker = this.myContext.getBuilder().mark();
        if (this.atToken((IElementType)PyTokenTypes.IDENTIFIER)) {
            this.nextToken();
            result = this.atToken((IElementType)PyTokenTypes.DOT);
        }
        marker.rollbackTo();
        return result;
    }

    private boolean atBaseTypeToken() {
        String s = this.myContext.getBuilder().getTokenText();
        return CythonNames.BASE_C_TYPES.contains((Object)s) || CythonNames.BASE_CYTHON_TYPES.contains((Object)s) || CythonNames.BASE_TYPE_MODIFIERS.contains((Object)s);
    }

    private boolean parseIdentifier() {
        return this.checkMatches((IElementType)PyTokenTypes.IDENTIFIER, PyParsingBundle.message((String)"PARSE.expected.identifier", (Object[])new Object[0]));
    }

    protected boolean checkMatches(@NotNull String text, @Nls @NotNull String message) {
        if (text == null) {
            CythonDeclParsing.$$$reportNull$$$0(0);
        }
        if (message == null) {
            CythonDeclParsing.$$$reportNull$$$0(1);
        }
        if (text.equals(this.myBuilder.getTokenText())) {
            this.myBuilder.advanceLexer();
            return true;
        }
        this.myBuilder.error(message);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/pro/cython/parser/CythonDeclParsing";
        objectArray[2] = "checkMatches";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum DeclaratorType {
        EMPTY,
        VARIABLE,
        FUNCTION;

    }
}

