/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.profiler.ui.ExpandEventContentButton;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/MyEventContentButtonUI;", "Ljavax/swing/plaf/basic/BasicButtonUI;", "<init>", "()V", "myIconRect", "Ljava/awt/Rectangle;", "myTextRect", "myViewRect", "insets", "Ljava/awt/Insets;", "getMinimumSize", "Ljava/awt/Dimension;", "c", "Ljavax/swing/JComponent;", "getMaximumSize", "getPreferredSize", "update", "", "g", "Ljava/awt/Graphics;", "Companion", "intellij.profiler.common"})
final class MyEventContentButtonUI
extends BasicButtonUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rectangle myIconRect = new Rectangle();
    @NotNull
    private final Rectangle myTextRect = new Rectangle();
    @NotNull
    private final Rectangle myViewRect = new Rectangle();
    @NotNull
    private Insets insets;
    @NotNull
    private static final Color HOVER_BACKGROUND_COLOR;

    public MyEventContentButtonUI() {
        JBInsets jBInsets = JBInsets.emptyInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
        this.insets = (Insets)jBInsets;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return this.getPreferredSize(c);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return this.getPreferredSize(c);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"DEFAULT_MINIMUM_BUTTON_SIZE");
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull Graphics g, @NotNull JComponent c) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ExpandEventContentButton button = (ExpandEventContentButton)c;
        String text = button.getText();
        Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = button.getFontMetrics(button.getFont());
        this.insets = button.getInsets(this.insets);
        this.myViewRect.x = this.insets.left;
        this.myViewRect.y = this.insets.top;
        this.myViewRect.height = button.getWidth() - (this.insets.left + this.insets.right);
        this.myViewRect.width = button.getHeight() - (this.insets.top + this.insets.bottom);
        this.myIconRect.x = this.myIconRect.y = (this.myIconRect.width = (this.myIconRect.height = 0));
        this.myTextRect.x = this.myTextRect.y = (this.myTextRect.width = (this.myTextRect.height = 0));
        String clippedText = SwingUtilities.layoutCompoundLabel(button, fm, text, icon, 0, 2, 0, 11, this.myViewRect, this.myIconRect, this.myTextRect, text == null ? 0 : button.getIconTextGap());
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ButtonModel model2 = button.getModel();
            Rectangle rectangle = this.myIconRect;
            rectangle.x -= JBUIScale.scale((int)2);
            rectangle = this.myTextRect;
            rectangle.x -= JBUIScale.scale((int)2);
            g2.setColor(model2.isRollover() || model2.isPressed() ? HOVER_BACKGROUND_COLOR : button.getBackground());
            g2.fillRect(0, 0, button.getWidth(), button.getHeight());
            Icon icon3 = icon;
            if (icon3 != null) {
                icon3.paintIcon(button, g2, this.myIconRect.y, JBUIScale.scale((int)(2 * button.getIconTextGap())));
            }
            g2.rotate(1.5707963267948966);
            g2.translate(this.myIconRect.width, -button.getWidth());
            UISettings.Companion.setupAntialiasing((Graphics)g2);
            if (text != null) {
                if (model2.isEnabled()) {
                    g2.setColor(button.getForeground());
                } else {
                    g2.setColor(UIManager.getColor("Button.disabledText"));
                }
                BasicGraphicsUtils.drawString(g2, clippedText, 0, this.myTextRect.x, this.myTextRect.y + fm.getAscent());
            }
        }
        finally {
            g2.dispose();
        }
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"ToolWindow.Button.hoverBackground", (Color)((Color)new JBColor(Gray.x55.withAlpha(40), Gray.x0F.withAlpha(40))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        HOVER_BACKGROUND_COLOR = (Color)jBColor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ui/MyEventContentButtonUI$Companion;", "", "<init>", "()V", "HOVER_BACKGROUND_COLOR", "Ljava/awt/Color;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

