/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.collection.LruCache;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.CacheTextLayoutInput;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bR\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/text/TextLayoutCache;", "", "capacity", "", "(I)V", "cache", "Landroidx/collection/LruCache;", "Landroidx/compose/ui/text/CacheTextLayoutInput;", "Landroidx/compose/ui/text/TextLayoutResult;", "singleSizeCacheInput", "singleSizeCacheResult", "get", "key", "Landroidx/compose/ui/text/TextLayoutInput;", "put", "", "value", "ui-text"})
@StabilityInferred(parameters=0)
public final class TextLayoutCache {
    @Nullable
    private final LruCache<CacheTextLayoutInput, TextLayoutResult> cache;
    @Nullable
    private CacheTextLayoutInput singleSizeCacheInput;
    @Nullable
    private TextLayoutResult singleSizeCacheResult;
    public static final int $stable = 8;

    public TextLayoutCache(int capacity) {
        this.cache = capacity != 1 ? new LruCache(capacity) : null;
    }

    public /* synthetic */ TextLayoutCache(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        this(n);
    }

    @Nullable
    public final TextLayoutResult get(@NotNull TextLayoutInput key) {
        TextLayoutResult textLayoutResult;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CacheTextLayoutInput cacheKey = new CacheTextLayoutInput(key);
        if (this.cache != null) {
            textLayoutResult = this.cache.get(cacheKey);
        } else if (Intrinsics.areEqual((Object)this.singleSizeCacheInput, (Object)cacheKey)) {
            textLayoutResult = this.singleSizeCacheResult;
        } else {
            return null;
        }
        TextLayoutResult resultFromCache = textLayoutResult;
        if (resultFromCache == null) {
            return null;
        }
        if (resultFromCache.getMultiParagraph().getIntrinsics().getHasStaleResolvedFonts()) {
            return null;
        }
        return resultFromCache;
    }

    public final void put(@NotNull TextLayoutInput key, @NotNull TextLayoutResult value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.cache != null) {
            this.cache.put(new CacheTextLayoutInput(key), value);
        } else {
            this.singleSizeCacheInput = new CacheTextLayoutInput(key);
            this.singleSizeCacheResult = value;
        }
    }

    public TextLayoutCache() {
        this(0, 1, null);
    }
}

