/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trialPromotion;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.trialPromotion.StandardTrialPromotionBundle;
import com.intellij.platform.trialPromotion.TrialStateButton;
import com.intellij.platform.trialPromotion.TrialStateService;
import com.intellij.util.PlatformUtils;
import java.nio.file.FileVisitResult;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\r\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0000\u001a\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0013H\u0002\u001a\u001a\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000f\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\"$\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"isRestartRequired", "", "unlockSubscriptionMessage", "", "Lorg/jetbrains/annotations/Nls;", "LAST_STATE_KEY", "LAST_COLOR_CLICKED_KEY", "ALERT_REMAINED_DAYS", "", "EXPIRING_REMAINED_DAYS", "GRACE_DAYS", "TOOLTIP_TRIAL_STARTED_ID", "TOOLTIP_REMAINED_DAYS_ID", "TOOLTIP_EXPIRING_DAYS_ID", "TOOLTIP_GRACE_DAYS_ID", "testRemainingDays", "getTestRemainingDays", "()Ljava/lang/Integer;", "value", "Lcom/intellij/platform/trialPromotion/TrialStateService$TrialState;", "lastTrialState", "getLastTrialState", "()Lcom/intellij/platform/trialPromotion/TrialStateService$TrialState;", "setLastTrialState", "(Lcom/intellij/platform/trialPromotion/TrialStateService$TrialState;)V", "lastColorStateClicked", "getLastColorStateClicked", "()Z", "setLastColorStateClicked", "(Z)V", "getColorState", "Lcom/intellij/platform/trialPromotion/TrialStateButton$ColorState;", "trialState", "getTrialState", "remainedDays", "trialLengthDays", "intellij.platform.trialPromotion"})
@SourceDebugExtension(value={"SMAP\nTrialStateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrialStateService.kt\ncom/intellij/platform/trialPromotion/TrialStateServiceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,376:1\n1755#2,3:377\n*S KotlinDebug\n*F\n+ 1 TrialStateService.kt\ncom/intellij/platform/trialPromotion/TrialStateServiceKt\n*L\n293#1:377,3\n*E\n"})
public final class TrialStateServiceKt {
    @NotNull
    private static final String LAST_STATE_KEY = "trial.state.last.state";
    @NotNull
    private static final String LAST_COLOR_CLICKED_KEY = "trial.state.last.color.state.clicked";
    private static final int ALERT_REMAINED_DAYS = 7;
    private static final int EXPIRING_REMAINED_DAYS = 1;
    private static final int GRACE_DAYS = -1;
    @NotNull
    private static final String TOOLTIP_TRIAL_STARTED_ID = "trial.state.widget.trial.started.got.it.id";
    @NotNull
    private static final String TOOLTIP_REMAINED_DAYS_ID = "trial.state.widget.remained.days.got.it.id";
    @NotNull
    private static final String TOOLTIP_EXPIRING_DAYS_ID = "trial.state.widget.expiring.got.it.id";
    @NotNull
    private static final String TOOLTIP_GRACE_DAYS_ID = "trial.state.widget.grace.got.it.id";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRestartRequired() {
        boolean bl;
        Map idMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
        if (PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID)) return false;
        Iterable $this$any$iv = SetsKt.minus((Set)ArraysKt.toSet((Object[])PluginManagerCore.getPlugins()), (Iterable)PluginManagerCore.getLoadedPlugins());
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv;
            boolean bl2 = false;
            PluginId pluginId = it.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
            if (!PluginManagerCore.isDisabled((PluginId)pluginId) && it instanceof IdeaPluginDescriptorImpl && !((IdeaPluginDescriptorImpl)it).isImplementationDetail() && ((IdeaPluginDescriptorImpl)it).isBundled() && !PluginManagerCore.INSTANCE.processAllNonOptionalDependencies((IdeaPluginDescriptorImpl)it, idMap, TrialStateServiceKt::isRestartRequired$lambda$1$lambda$0)) {
                boolean bl3;
                Object object = PluginManagerCore.INSTANCE.getLoadingError(((IdeaPluginDescriptorImpl)it).getPluginId());
                if (object != null && (object = object.getInternalMessage()) != null) {
                    CharSequence charSequence = (CharSequence)object;
                    String string = PluginManagerCore.ULTIMATE_PLUGIN_ID.getIdString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
                    if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final String unlockSubscriptionMessage() {
        Object[] objectArray = new Object[]{PlatformUtils.isPyCharm() ? "Pro" : "Ultimate"};
        return StandardTrialPromotionBundle.INSTANCE.message("trial.state.free", objectArray);
    }

    private static final Integer getTestRemainingDays() {
        int result = Registry.Companion.intValue("trial.state.test.remaining.days", -100);
        return result == -100 ? null : Integer.valueOf(result);
    }

    private static final TrialStateService.TrialState getLastTrialState() {
        TrialStateService.TrialState trialState;
        String string = PropertiesComponent.getInstance().getValue(LAST_STATE_KEY);
        if (string != null) {
            TrialStateService.TrialState trialState2;
            String it = string;
            boolean bl = false;
            try {
                trialState2 = TrialStateService.TrialState.valueOf(it);
            }
            catch (Exception exception) {
                trialState2 = null;
            }
            trialState = trialState2;
        } else {
            trialState = null;
        }
        return trialState;
    }

    private static final void setLastTrialState(TrialStateService.TrialState value) {
        TrialStateService.TrialState trialState = value;
        PropertiesComponent.getInstance().setValue(LAST_STATE_KEY, trialState != null ? trialState.name() : null);
    }

    private static final boolean getLastColorStateClicked() {
        return PropertiesComponent.getInstance().getBoolean(LAST_COLOR_CLICKED_KEY, false);
    }

    private static final void setLastColorStateClicked(boolean value) {
        PropertiesComponent.getInstance().setValue(LAST_COLOR_CLICKED_KEY, value);
    }

    private static final TrialStateButton.ColorState getColorState(TrialStateService.TrialState trialState) {
        return switch (WhenMappings.$EnumSwitchMapping$0[trialState.ordinal()]) {
            case 1 -> TrialStateButton.ColorState.DEFAULT;
            case 2, 3 -> TrialStateButton.ColorState.ACTIVE;
            case 4 -> TrialStateButton.ColorState.ALERT;
            case 5, 6, 7 -> TrialStateButton.ColorState.EXPIRING;
            case 8 -> TrialStateButton.ColorState.EXPIRING;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final TrialStateService.TrialState getTrialState(int remainedDays, int trialLengthDays) {
        boolean isRestartRequired = TrialStateServiceKt.isRestartRequired();
        boolean isFreeMode = PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
        return isRestartRequired ? TrialStateService.TrialState.RESTART_REQUIRED : (isFreeMode ? TrialStateService.TrialState.FREE : (trialLengthDays > 0 && remainedDays == trialLengthDays ? TrialStateService.TrialState.TRIAL_STARTED : (remainedDays > 7 ? TrialStateService.TrialState.ACTIVE : (remainedDays > 1 ? TrialStateService.TrialState.ALERT : (remainedDays > 0 ? TrialStateService.TrialState.EXPIRING : (remainedDays > -1 ? TrialStateService.TrialState.GRACE : (remainedDays == -1 ? TrialStateService.TrialState.GRACE_ENDED : null)))))));
    }

    private static final FileVisitResult isRestartRequired$lambda$1$lambda$0(IdeaPluginDescriptorImpl descriptorImpl) {
        Intrinsics.checkNotNullParameter((Object)descriptorImpl, (String)"descriptorImpl");
        return Intrinsics.areEqual((Object)descriptorImpl.getPluginId(), (Object)PluginManagerCore.ULTIMATE_PLUGIN_ID) ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    public static final /* synthetic */ Integer access$getTestRemainingDays() {
        return TrialStateServiceKt.getTestRemainingDays();
    }

    public static final /* synthetic */ TrialStateService.TrialState access$getTrialState(int remainedDays, int trialLengthDays) {
        return TrialStateServiceKt.getTrialState(remainedDays, trialLengthDays);
    }

    public static final /* synthetic */ TrialStateButton.ColorState access$getColorState(TrialStateService.TrialState trialState) {
        return TrialStateServiceKt.getColorState(trialState);
    }

    public static final /* synthetic */ TrialStateService.TrialState access$getLastTrialState() {
        return TrialStateServiceKt.getLastTrialState();
    }

    public static final /* synthetic */ void access$setLastColorStateClicked(boolean value) {
        TrialStateServiceKt.setLastColorStateClicked(value);
    }

    public static final /* synthetic */ void access$setLastTrialState(TrialStateService.TrialState value) {
        TrialStateServiceKt.setLastTrialState(value);
    }

    public static final /* synthetic */ boolean access$getLastColorStateClicked() {
        return TrialStateServiceKt.getLastColorStateClicked();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrialStateService.TrialState.values().length];
            try {
                nArray[TrialStateService.TrialState.FREE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.TRIAL_STARTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.ALERT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.EXPIRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.GRACE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.GRACE_ENDED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.RESTART_REQUIRED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

