/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitUserRegistry;
import git4idea.commit.GitMyRecentCommitsProvider;
import git4idea.history.GitLogCommandParameters;
import git4idea.history.GitLogUtil;
import git4idea.log.GitLogProvider;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryStateChangeListener;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000bH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/commit/GitMyRecentCommitsProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "requestedDepth", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "cache", "Lcom/github/benmanes/caffeine/cache/AsyncLoadingCache;", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getRecentCommits", "root", "limit", "(Lcom/intellij/openapi/vfs/VirtualFile;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readRecentCommits", "Companion", "intellij.vcs.git"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGitMyRecentCommitsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMyRecentCommitsProvider.kt\ngit4idea/commit/GitMyRecentCommitsProvider\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,97:1\n95#2:98\n135#2,3:99\n25#3:102\n*S KotlinDebug\n*F\n+ 1 GitMyRecentCommitsProvider.kt\ngit4idea/commit/GitMyRecentCommitsProvider\n*L\n83#1:98\n83#1:99,3\n93#1:102\n*E\n"})
public final class GitMyRecentCommitsProvider {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Map<VirtualFile, Integer> requestedDepth;
    @NotNull
    private final AsyncLoadingCache<VirtualFile, List<VcsCommitMetadata>> cache;
    @NotNull
    private static final Logger LOG;

    public GitMyRecentCommitsProvider(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.requestedDepth = new ConcurrentHashMap();
        AsyncLoadingCache asyncLoadingCache = Caffeine.newBuilder().executor((Executor)AppExecutorUtil.getAppExecutorService()).buildAsync((arg_0, arg_1) -> GitMyRecentCommitsProvider.cache$lambda$2((arg_0, arg_1) -> GitMyRecentCommitsProvider.cache$lambda$1(this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)asyncLoadingCache, (String)"buildAsync(...)");
        this.cache = asyncLoadingCache;
        SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().connect(this.scope);
        Topic<GitRepositoryStateChangeListener> topic = GitRepository.GIT_REPO_STATE_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_STATE_CHANGE");
        simpleMessageBusConnection.subscribe(topic, (Object)new GitRepositoryStateChangeListener(){

            @Override
            public void repositoryChanged(GitRepository repository, GitRepoInfo previousInfo, GitRepoInfo info) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)previousInfo, (String)"previousInfo");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                LOG.debug("Refreshing cache entry for " + repository.getRoot());
                cache.synchronous().refresh((Object)repository.getRoot());
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getRecentCommits(@NotNull VirtualFile var1_1, int var2_2, @NotNull Continuation<? super List<? extends VcsCommitMetadata>> $completion) {
        if (!($completion instanceof getRecentCommits.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ GitMyRecentCommitsProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getRecentCommits(null, 0, (Continuation<? super List<? extends VcsCommitMetadata>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                shouldInvalidate = new Ref.BooleanRef();
                this.requestedDepth.compute((VirtualFile)root, (BiFunction<Object, Object, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getRecentCommits$lambda$4(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Integer;)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getRecentCommits$lambda$3(int kotlin.jvm.internal.Ref$BooleanRef com.intellij.openapi.vfs.VirtualFile java.lang.Integer ), (Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Integer;)Ljava/lang/Integer;)((int)limit, (Ref.BooleanRef)shouldInvalidate)));
                if (shouldInvalidate.element) {
                    GitMyRecentCommitsProvider.LOG.debug("Limit updated for " + (VirtualFile)root + " - " + limit);
                    this.cache.synchronous().invalidate((Object)root);
                }
                var6_8 = this.cache.get((Object)root);
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"get(...)");
                future = var6_8;
                $continuation.I$0 = limit;
                $continuation.label = 1;
                v0 = FutureKt.await((CompletionStage)future, (Continuation)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl31
            }
            case 1: {
                limit = $continuation.I$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"await(...)");
                return CollectionsKt.take((Iterable)((Iterable)v0), (int)limit);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @RequiresBackgroundThread
    private final List<VcsCommitMetadata> readRecentCommits(VirtualFile root, int limit) {
        LOG.debug("Reading recent commits for " + root);
        VcsUser vcsUser = GitUserRegistry.getInstance(this.project).getOrReadUser(root);
        if (vcsUser == null) {
            return CollectionsKt.emptyList();
        }
        VcsUser currentUser = vcsUser;
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{VcsLogFilterObject.fromBranch((String)"HEAD"), VcsLogFilterObject.fromUser$default((VcsUser)currentUser, null, (int)2, null)};
        VcsLogFilterCollection filters = VcsLogFilterObject.collection((VcsLogFilter[])vcsLogFilterArray);
        GitLogCommandParameters gitLogCommandParameters = GitLogProvider.getGitLogParameters(this.project, root, filters, null, (PermanentGraph.Options)PermanentGraph.Options.Default, limit);
        if (gitLogCommandParameters == null) {
            return CollectionsKt.emptyList();
        }
        GitLogCommandParameters parameters = gitLogCommandParameters;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        List result$iv$iv = GitLogUtil.collectMetadata(this.project, root, parameters).getCommits();
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        Object object = timedValue.component1();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
        List commits = (List)object;
        long duration = timedValue.component2-UwyO8pc();
        LOG.debug("Loaded " + commits.size() + " commits for " + root + " in " + Duration.toString-impl((long)duration) + "ms");
        return commits;
    }

    private static final CompletableFuture cache$lambda$1(GitMyRecentCommitsProvider this$0, VirtualFile root, Executor executor) {
        CompletableFuture completableFuture;
        Integer n = this$0.requestedDepth.get(root);
        if (n != null) {
            int commitsToLoad = ((Number)n).intValue();
            boolean bl = false;
            completableFuture = FutureKt.future$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends VcsCommitMetadata>>, Object>(this$0, root, commitsToLoad, null){
                int label;
                final /* synthetic */ GitMyRecentCommitsProvider this$0;
                final /* synthetic */ VirtualFile $root;
                final /* synthetic */ int $commitsToLoad;
                {
                    this.this$0 = $receiver;
                    this.$root = $root;
                    this.$commitsToLoad = $commitsToLoad;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            VirtualFile virtualFile = this.$root;
                            Intrinsics.checkNotNull((Object)virtualFile);
                            return GitMyRecentCommitsProvider.access$readRecentCommits(this.this$0, virtualFile, this.$commitsToLoad);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends VcsCommitMetadata>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            completableFuture = null;
        }
        return completableFuture;
    }

    private static final CompletableFuture cache$lambda$2(Function2 $tmp0, Object key, Executor executor) {
        return (CompletableFuture)$tmp0.invoke(key, (Object)executor);
    }

    private static final Integer getRecentCommits$lambda$3(int $limit, Ref.BooleanRef $shouldInvalidate, VirtualFile virtualFile, Integer current) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
        if (current == null || current < $limit) {
            $shouldInvalidate.element = true;
            n = $limit;
        } else {
            n = current;
        }
        return n;
    }

    private static final Integer getRecentCommits$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ List access$readRecentCommits(GitMyRecentCommitsProvider $this, VirtualFile root, int limit) {
        return $this.readRecentCommits(root, limit);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/commit/GitMyRecentCommitsProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lgit4idea/commit/GitMyRecentCommitsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitMyRecentCommitsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMyRecentCommitsProvider.kt\ngit4idea/commit/GitMyRecentCommitsProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n31#2,2:98\n*S KotlinDebug\n*F\n+ 1 GitMyRecentCommitsProvider.kt\ngit4idea/commit/GitMyRecentCommitsProvider$Companion\n*L\n95#1:98,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitMyRecentCommitsProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitMyRecentCommitsProvider> serviceClass$iv = GitMyRecentCommitsProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GitMyRecentCommitsProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

