/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.hover.TreeHoverListener;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.branch.LinkedBranchDataImpl;
import com.intellij.vcsUtil.VcsImplUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.branch.GitIncomingOutgoingStateKt;
import git4idea.branch.IncomingOutgoingState;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitBranchesTreeIconProvider;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesTreeKt;
import git4idea.ui.branch.dashboard.BranchesTreeSelection;
import git4idea.ui.branch.dashboard.RefInfo;
import git4idea.ui.branch.tree.GitBranchesWithDetailsTreeRendererKt;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "searchField", "Lcom/intellij/ui/SearchTextField;", "getSearchField", "()Lcom/intellij/ui/SearchTextField;", "setSearchField", "(Lcom/intellij/ui/SearchTextField;)V", "hasFocus", "", "getSelection", "Lgit4idea/ui/branch/dashboard/BranchesTreeSelection;", "initDnD", "", "BranchTreeCellRenderer", "intellij.vcs.git"})
public final class BranchesTreeComponent
extends DnDAwareTree {
    @Nullable
    private SearchTextField searchField;

    public BranchesTreeComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.putClientProperty(DnDAwareTree.AUTO_SELECT_ON_MOUSE_PRESSED, false);
        this.setCellRenderer((TreeCellRenderer)((Object)new BranchTreeCellRenderer(project)));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        this.setHorizontalAutoScrollingEnabled(false);
        SmartExpander.installOn((JTree)((JTree)((Object)this)));
        TreeHoverListener.DEFAULT.addTo((JComponent)((Object)this));
        this.initDnD();
    }

    @Nullable
    public final SearchTextField getSearchField() {
        return this.searchField;
    }

    public final void setSearchField(@Nullable SearchTextField searchTextField) {
        this.searchField = searchTextField;
    }

    public boolean hasFocus() {
        SearchTextField searchTextField;
        return super.hasFocus() || ((searchTextField = this.searchField) != null && (searchTextField = searchTextField.getTextEditor()) != null ? searchTextField.hasFocus() : false);
    }

    @NotNull
    public final BranchesTreeSelection getSelection() {
        return new BranchesTreeSelection(this.getSelectionPaths());
    }

    private final void initDnD() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setTransferHandler(BranchesTreeKt.access$getBRANCH_TREE_TRANSFER_HANDLER$p());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0014J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeComponent$BranchTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;Lcom/intellij/openapi/project/Project;)V", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "Lorg/jetbrains/annotations/NotNull;", "branchManager", "Lgit4idea/ui/branch/GitBranchManager;", "iconProvider", "Lgit4idea/ui/branch/GitBranchesTreeIconProvider;", "incomingLabel", "Ljavax/swing/JLabel;", "outgoingLabel", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "calcFocusedState", "getBranchesTooltipData", "", "Lcom/intellij/vcs/branch/BranchData;", "branchName", "", "repositories", "", "Lgit4idea/repo/GitRepository;", "paint", "g", "Ljava/awt/Graphics;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/BranchesTreeComponent$BranchTreeCellRenderer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,518:1\n31#2,2:519\n1557#3:521\n1628#3,3:522\n*S KotlinDebug\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/BranchesTreeComponent$BranchTreeCellRenderer\n*L\n80#1:519,2\n145#1:521\n145#1:522,3\n*E\n"})
    private final class BranchTreeCellRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final GitRepositoryManager repositoryManager;
        @NotNull
        private final GitBranchManager branchManager;
        @NotNull
        private final GitBranchesTreeIconProvider iconProvider;
        @NotNull
        private final JLabel incomingLabel;
        @NotNull
        private final JLabel outgoingLabel;

        public BranchTreeCellRenderer(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
            this.repositoryManager = gitRepositoryManager;
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            this.branchManager = (GitBranchManager)((Object)object);
            this.iconProvider = new GitBranchesTreeIconProvider(project);
            this.incomingLabel = GitBranchesWithDetailsTreeRendererKt.createIncomingLabel();
            this.outgoingLabel = GitBranchesWithDetailsTreeRendererKt.createOutgoingLabel();
        }

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean repositoryGrouping;
            RefInfo refInfo;
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            if (!(value instanceof BranchTreeNode)) {
                return;
            }
            BranchNodeDescriptor descriptor = ((BranchTreeNode)value).getNodeDescriptor();
            BranchNodeDescriptor branchNodeDescriptor = descriptor;
            this.setIcon(branchNodeDescriptor instanceof BranchNodeDescriptor.Ref ? GitBranchesTreeIconProvider.forRef$default(this.iconProvider, ((BranchNodeDescriptor.Ref)descriptor).getRefInfo().getRef(), ((BranchNodeDescriptor.Ref)descriptor).getRefInfo().isCurrent(), ((BranchNodeDescriptor.Ref)descriptor).getRefInfo().isFavorite(), selected, false, 16, null) : (branchNodeDescriptor instanceof BranchNodeDescriptor.Group || branchNodeDescriptor instanceof BranchNodeDescriptor.RemoteGroup ? this.iconProvider.forGroup() : (branchNodeDescriptor instanceof BranchNodeDescriptor.Repository ? (Icon)this.iconProvider.forRepository(((BranchNodeDescriptor.Repository)descriptor).getRepository()) : null)));
            this.append(((BranchTreeNode)value).getNodeDescriptor().getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            BranchNodeDescriptor.Ref ref = descriptor instanceof BranchNodeDescriptor.Ref ? (BranchNodeDescriptor.Ref)descriptor : null;
            RefInfo refInfo2 = refInfo = ref != null ? ref.getRefInfo() : null;
            if (refInfo != null && !(repositoryGrouping = this.branchManager.isGroupingEnabled(GroupingKey.GROUPING_BY_REPOSITORY)) && refInfo.getRepositories().size() < this.repositoryManager.getRepositories().size()) {
                this.append(" (" + DvcsUtil.getShortNames((Collection)refInfo.getRepositories()) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            if (refInfo instanceof BranchInfo) {
                this.setToolTipText(((BranchInfo)refInfo).isLocalBranch() ? BranchPresentation.INSTANCE.getTooltip((Collection)this.getBranchesTooltipData(((BranchInfo)refInfo).getBranchName(), (Collection<? extends GitRepository>)BranchesTreeSelection.Companion.getSelectedRepositories((BranchTreeNode)value))) : null);
                IncomingOutgoingState incomingOutgoingState = ((BranchInfo)refInfo).getIncomingOutgoingState();
                GitBranchesWithDetailsTreeRendererKt.updateIncomingCommitLabel(this.incomingLabel, incomingOutgoingState);
                GitBranchesWithDetailsTreeRendererKt.updateOutgoingCommitLabel(this.outgoingLabel, incomingOutgoingState);
                FontMetrics fontMetrics = this.incomingLabel.getFontMetrics(this.incomingLabel.getFont());
                this.incomingLabel.setSize(new Dimension(fontMetrics.stringWidth(this.incomingLabel.getText()) + JBUI.scale((int)1) + this.incomingLabel.getIcon().getIconWidth(), fontMetrics.getHeight()));
                this.outgoingLabel.setSize(new Dimension(fontMetrics.stringWidth(this.outgoingLabel.getText()) + JBUI.scale((int)1) + this.outgoingLabel.getIcon().getIconWidth(), fontMetrics.getHeight()));
                tree.setToolTipText(GitIncomingOutgoingStateKt.calcTooltip(incomingOutgoingState));
            } else {
                this.incomingLabel.setVisible(false);
                this.outgoingLabel.setVisible(false);
                tree.setToolTipText(null);
            }
        }

        protected boolean calcFocusedState() {
            SearchTextField searchTextField;
            return super.calcFocusedState() || ((searchTextField = BranchesTreeComponent.this.getSearchField()) != null && (searchTextField = searchTextField.getTextEditor()) != null ? searchTextField.hasFocus() : false);
        }

        /*
         * WARNING - void declaration
         */
        private final List<BranchData> getBranchesTooltipData(String branchName, Collection<? extends GitRepository> repositories) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = repositories;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String presentableRootName;
                void repo2;
                GitRepository gitRepository = (GitRepository)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GitBranch gitBranch = repo2.getBranches().findLocalBranch(branchName);
                String trackedBranchName = gitBranch != null && (gitBranch = ((GitLocalBranch)gitBranch).findTrackedBranch((GitRepository)repo2)) != null ? gitBranch.getName() : null;
                Intrinsics.checkNotNullExpressionValue((Object)VcsImplUtil.getShortVcsRootName((Project)repo2.getProject(), (VirtualFile)repo2.getRoot()), (String)"getShortVcsRootName(...)");
                collection.add(new LinkedBranchDataImpl(presentableRootName, branchName, trackedBranchName));
            }
            return (List)destination$iv$iv;
        }

        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paint(g);
            int xOffset = this.getPreferredSize().width + this.getTree().getInsets().left;
            boolean yShifted = false;
            if (this.incomingLabel.isVisible()) {
                Icon incIcon = this.incomingLabel.getIcon();
                g.translate(xOffset, (this.getSize().height - incIcon.getIconHeight()) / 2);
                yShifted = true;
                this.incomingLabel.paint(g);
                xOffset = this.incomingLabel.getWidth() + JBUI.scale((int)3);
            }
            if (this.outgoingLabel.isVisible()) {
                Icon outIcon = this.outgoingLabel.getIcon();
                g.translate(xOffset, yShifted ? 0 : (this.getSize().height - outIcon.getIconHeight()) / 2);
                this.outgoingLabel.paint(g);
            }
        }
    }
}

