/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.state;

import com.jetbrains.plugins.vagrant.state.Resolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\r\u001a\u00028\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugins/vagrant/state/FileCache;", "T", "", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "contentLock", "Ljava/lang/Object;", "fileContent", "Lcom/jetbrains/plugins/vagrant/state/FileCache$FileContent;", "getContent", "resolver", "Lcom/jetbrains/plugins/vagrant/state/Resolver;", "(Lcom/jetbrains/plugins/vagrant/state/Resolver;)Ljava/lang/Object;", "FileContent", "intellij.vagrant"})
public class FileCache<T> {
    @NotNull
    private final Path path;
    @NotNull
    private final Object contentLock;
    @Nullable
    private FileContent<? extends T> fileContent;

    public FileCache(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.contentLock = new Object();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getContent(@NotNull Resolver<? extends T> resolver2) throws IOException {
        Intrinsics.checkNotNullParameter(resolver2, (String)"resolver");
        FileTime modifiedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
        Object object = this.contentLock;
        synchronized (object) {
            T currentContent;
            block5: {
                boolean bl = false;
                FileContent<T> fileContent = this.fileContent;
                Object object2 = currentContent = fileContent != null ? fileContent.getContent() : null;
                if (currentContent != null) {
                    FileContent<T> fileContent2 = this.fileContent;
                    if (Intrinsics.areEqual((Object)modifiedTime, (Object)(fileContent2 != null ? fileContent2.getLastModifiedTime() : null))) break block5;
                }
                currentContent = resolver2.resolve(this.path);
                Intrinsics.checkNotNull((Object)modifiedTime);
                this.fileContent = new FileContent<T>(this.path, modifiedTime, currentContent);
                T t = currentContent;
                return t;
            }
            T t = currentContent;
            return t;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\u000e\u0010\u0013\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugins/vagrant/state/FileCache$FileContent;", "T", "", "path", "Ljava/nio/file/Path;", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "content", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/attribute/FileTime;Ljava/lang/Object;)V", "getPath", "()Ljava/nio/file/Path;", "getLastModifiedTime", "()Ljava/nio/file/attribute/FileTime;", "getContent", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/nio/file/Path;Ljava/nio/file/attribute/FileTime;Ljava/lang/Object;)Lcom/jetbrains/plugins/vagrant/state/FileCache$FileContent;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vagrant"})
    public static final class FileContent<T> {
        @NotNull
        private final Path path;
        @NotNull
        private final FileTime lastModifiedTime;
        private final T content;

        public FileContent(@NotNull Path path, @NotNull FileTime lastModifiedTime, T content) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)lastModifiedTime, (String)"lastModifiedTime");
            this.path = path;
            this.lastModifiedTime = lastModifiedTime;
            this.content = content;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final FileTime getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final T getContent() {
            return this.content;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        @NotNull
        public final FileTime component2() {
            return this.lastModifiedTime;
        }

        public final T component3() {
            return this.content;
        }

        @NotNull
        public final FileContent<T> copy(@NotNull Path path, @NotNull FileTime lastModifiedTime, T content) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)lastModifiedTime, (String)"lastModifiedTime");
            return new FileContent<T>(path, lastModifiedTime, content);
        }

        public static /* synthetic */ FileContent copy$default(FileContent fileContent, Path path, FileTime fileTime, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                path = fileContent.path;
            }
            if ((n & 2) != 0) {
                fileTime = fileContent.lastModifiedTime;
            }
            if ((n & 4) != 0) {
                object = fileContent.content;
            }
            return fileContent.copy(path, fileTime, object);
        }

        @NotNull
        public String toString() {
            return "FileContent(path=" + this.path + ", lastModifiedTime=" + this.lastModifiedTime + ", content=" + this.content + ")";
        }

        public int hashCode() {
            int result = ((Object)this.path).hashCode();
            result = result * 31 + this.lastModifiedTime.hashCode();
            result = result * 31 + (this.content == null ? 0 : this.content.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileContent)) {
                return false;
            }
            FileContent fileContent = (FileContent)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)fileContent.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastModifiedTime, (Object)fileContent.lastModifiedTime)) {
                return false;
            }
            return Intrinsics.areEqual(this.content, fileContent.content);
        }
    }
}

